(* ::Package:: *)

(* ::Title:: *)
(*Integration Problems Involving the Polylogarithm Function*)


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m PolyLog[n, a x^q]*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m PolyLog[n, a x^q]*)


(* ::Subsubsection::Closed:: *)
(*q=1*)


{x^4*PolyLog[2, a*x], x, 4, -(x/(25*a^4)) - x^2/(50*a^3) - x^3/(75*a^2) - x^4/(100*a) - x^5/125 - Log[1 - a*x]/(25*a^5) + (1/25)*x^5*Log[1 - a*x] + (1/5)*x^5*PolyLog[2, a*x]}
{x^3*PolyLog[2, a*x], x, 4, -(x/(16*a^3)) - x^2/(32*a^2) - x^3/(48*a) - x^4/64 - Log[1 - a*x]/(16*a^4) + (1/16)*x^4*Log[1 - a*x] + (1/4)*x^4*PolyLog[2, a*x]}
{x^2*PolyLog[2, a*x], x, 4, -(x/(9*a^2)) - x^2/(18*a) - x^3/27 - Log[1 - a*x]/(9*a^3) + (1/9)*x^3*Log[1 - a*x] + (1/3)*x^3*PolyLog[2, a*x]}
{x^1*PolyLog[2, a*x], x, 4, -(x/(4*a)) - x^2/8 - Log[1 - a*x]/(4*a^2) + (1/4)*x^2*Log[1 - a*x] + (1/2)*x^2*PolyLog[2, a*x]}
{x^0*PolyLog[2, a*x], x, 3, -x - ((1 - a*x)*Log[1 - a*x])/a + x*PolyLog[2, a*x]}
{PolyLog[2, a*x]/x^1, x, 1, PolyLog[3, a*x]}
{PolyLog[2, a*x]/x^2, x, 5, a*Log[x] - a*Log[1 - a*x] + Log[1 - a*x]/x - PolyLog[2, a*x]/x}
{PolyLog[2, a*x]/x^3, x, 4, -(a/(4*x)) + (1/4)*a^2*Log[x] - (1/4)*a^2*Log[1 - a*x] + Log[1 - a*x]/(4*x^2) - PolyLog[2, a*x]/(2*x^2)}
{PolyLog[2, a*x]/x^4, x, 4, -(a/(18*x^2)) - a^2/(9*x) + (1/9)*a^3*Log[x] - (1/9)*a^3*Log[1 - a*x] + Log[1 - a*x]/(9*x^3) - PolyLog[2, a*x]/(3*x^3)}
{PolyLog[2, a*x]/x^5, x, 4, -(a/(48*x^3)) - a^2/(32*x^2) - a^3/(16*x) + (1/16)*a^4*Log[x] - (1/16)*a^4*Log[1 - a*x] + Log[1 - a*x]/(16*x^4) - PolyLog[2, a*x]/(4*x^4)}


{x^3*PolyLog[3, a*x], x, 5, x/(64*a^3) + x^2/(128*a^2) + x^3/(192*a) + x^4/256 + Log[1 - a*x]/(64*a^4) - (1/64)*x^4*Log[1 - a*x] - (1/16)*x^4*PolyLog[2, a*x] + (1/4)*x^4*PolyLog[3, a*x]}
{x^2*PolyLog[3, a*x], x, 5, x/(27*a^2) + x^2/(54*a) + x^3/81 + Log[1 - a*x]/(27*a^3) - (1/27)*x^3*Log[1 - a*x] - (1/9)*x^3*PolyLog[2, a*x] + (1/3)*x^3*PolyLog[3, a*x]}
{x^1*PolyLog[3, a*x], x, 5, x/(8*a) + x^2/16 + Log[1 - a*x]/(8*a^2) - (1/8)*x^2*Log[1 - a*x] - (1/4)*x^2*PolyLog[2, a*x] + (1/2)*x^2*PolyLog[3, a*x]}
{x^0*PolyLog[3, a*x], x, 4, x + ((1 - a*x)*Log[1 - a*x])/a - x*PolyLog[2, a*x] + x*PolyLog[3, a*x]}
{PolyLog[3, a*x]/x^1, x, 1, PolyLog[4, a*x]}
{PolyLog[3, a*x]/x^2, x, 6, a*Log[x] - a*Log[1 - a*x] + Log[1 - a*x]/x - PolyLog[2, a*x]/x - PolyLog[3, a*x]/x}
{PolyLog[3, a*x]/x^3, x, 5, -(a/(8*x)) + (1/8)*a^2*Log[x] - (1/8)*a^2*Log[1 - a*x] + Log[1 - a*x]/(8*x^2) - PolyLog[2, a*x]/(4*x^2) - PolyLog[3, a*x]/(2*x^2)}
{PolyLog[3, a*x]/x^4, x, 5, -(a/(54*x^2)) - a^2/(27*x) + (1/27)*a^3*Log[x] - (1/27)*a^3*Log[1 - a*x] + Log[1 - a*x]/(27*x^3) - PolyLog[2, a*x]/(9*x^3) - PolyLog[3, a*x]/(3*x^3)}


(* ::Subsubsection::Closed:: *)
(*q=2*)


{x^5*PolyLog[2, a*x^2], x, 5, -(x^2/(18*a^2)) - x^4/(36*a) - x^6/54 - Log[1 - a*x^2]/(18*a^3) + (1/18)*x^6*Log[1 - a*x^2] + (1/6)*x^6*PolyLog[2, a*x^2]}
{x^3*PolyLog[2, a*x^2], x, 5, -(x^2/(8*a)) - x^4/16 - Log[1 - a*x^2]/(8*a^2) + (1/8)*x^4*Log[1 - a*x^2] + (1/4)*x^4*PolyLog[2, a*x^2]}
{x^1*PolyLog[2, a*x^2], x, 4, -(x^2/2) - ((1 - a*x^2)*Log[1 - a*x^2])/(2*a) + (1/2)*x^2*PolyLog[2, a*x^2]}
{PolyLog[2, a*x^2]/x^1, x, 1, (1/2)*PolyLog[3, a*x^2]}
{PolyLog[2, a*x^2]/x^3, x, 6, a*Log[x] - (1/2)*a*Log[1 - a*x^2] + Log[1 - a*x^2]/(2*x^2) - PolyLog[2, a*x^2]/(2*x^2)}
{PolyLog[2, a*x^2]/x^5, x, 5, -(a/(8*x^2)) + (1/4)*a^2*Log[x] - (1/8)*a^2*Log[1 - a*x^2] + Log[1 - a*x^2]/(8*x^4) - PolyLog[2, a*x^2]/(4*x^4)}
{PolyLog[2, a*x^2]/x^7, x, 5, -(a/(36*x^4)) - a^2/(18*x^2) + (1/9)*a^3*Log[x] - (1/18)*a^3*Log[1 - a*x^2] + Log[1 - a*x^2]/(18*x^6) - PolyLog[2, a*x^2]/(6*x^6)}

{x^4*PolyLog[2, a*x^2], x, 5, -((4*x)/(25*a^2)) - (4*x^3)/(75*a) - (4*x^5)/125 + (4*ArcTanh[Sqrt[a]*x])/(25*a^(5/2)) + (2/25)*x^5*Log[1 - a*x^2] + (1/5)*x^5*PolyLog[2, a*x^2]}
{x^2*PolyLog[2, a*x^2], x, 5, -((4*x)/(9*a)) - (4*x^3)/27 + (4*ArcTanh[Sqrt[a]*x])/(9*a^(3/2)) + (2/9)*x^3*Log[1 - a*x^2] + (1/3)*x^3*PolyLog[2, a*x^2]}
{x^0*PolyLog[2, a*x^2], x, 4, -4*x + (4*ArcTanh[Sqrt[a]*x])/Sqrt[a] + 2*x*Log[1 - a*x^2] + x*PolyLog[2, a*x^2]}
{PolyLog[2, a*x^2]/x^2, x, 3, 4*Sqrt[a]*ArcTanh[Sqrt[a]*x] + (2*Log[1 - a*x^2])/x - PolyLog[2, a*x^2]/x}
{PolyLog[2, a*x^2]/x^4, x, 4, -((4*a)/(9*x)) + (4/9)*a^(3/2)*ArcTanh[Sqrt[a]*x] + (2*Log[1 - a*x^2])/(9*x^3) - PolyLog[2, a*x^2]/(3*x^3)}
{PolyLog[2, a*x^2]/x^6, x, 5, -((4*a)/(75*x^3)) - (4*a^2)/(25*x) + (4/25)*a^(5/2)*ArcTanh[Sqrt[a]*x] + (2*Log[1 - a*x^2])/(25*x^5) - PolyLog[2, a*x^2]/(5*x^5)}


{x^5*PolyLog[3, a*x^2], x, 6, x^2/(54*a^2) + x^4/(108*a) + x^6/162 + Log[1 - a*x^2]/(54*a^3) - (1/54)*x^6*Log[1 - a*x^2] - (1/18)*x^6*PolyLog[2, a*x^2] + (1/6)*x^6*PolyLog[3, a*x^2]}
{x^3*PolyLog[3, a*x^2], x, 6, x^2/(16*a) + x^4/32 + Log[1 - a*x^2]/(16*a^2) - (1/16)*x^4*Log[1 - a*x^2] - (1/8)*x^4*PolyLog[2, a*x^2] + (1/4)*x^4*PolyLog[3, a*x^2]}
{x^1*PolyLog[3, a*x^2], x, 5, x^2/2 + ((1 - a*x^2)*Log[1 - a*x^2])/(2*a) - (1/2)*x^2*PolyLog[2, a*x^2] + (1/2)*x^2*PolyLog[3, a*x^2]}
{PolyLog[3, a*x^2]/x^1, x, 1, (1/2)*PolyLog[4, a*x^2]}
{PolyLog[3, a*x^2]/x^3, x, 7, a*Log[x] - (1/2)*a*Log[1 - a*x^2] + Log[1 - a*x^2]/(2*x^2) - PolyLog[2, a*x^2]/(2*x^2) - PolyLog[3, a*x^2]/(2*x^2)}
{PolyLog[3, a*x^2]/x^5, x, 6, -(a/(16*x^2)) + (1/8)*a^2*Log[x] - (1/16)*a^2*Log[1 - a*x^2] + Log[1 - a*x^2]/(16*x^4) - PolyLog[2, a*x^2]/(8*x^4) - PolyLog[3, a*x^2]/(4*x^4)}
{PolyLog[3, a*x^2]/x^7, x, 6, -(a/(108*x^4)) - a^2/(54*x^2) + (1/27)*a^3*Log[x] - (1/54)*a^3*Log[1 - a*x^2] + Log[1 - a*x^2]/(54*x^6) - PolyLog[2, a*x^2]/(18*x^6) - PolyLog[3, a*x^2]/(6*x^6)}

{x^4*PolyLog[3, a*x^2], x, 6, (8*x)/(125*a^2) + (8*x^3)/(375*a) + (8*x^5)/625 - (8*ArcTanh[Sqrt[a]*x])/(125*a^(5/2)) - (4/125)*x^5*Log[1 - a*x^2] - (2/25)*x^5*PolyLog[2, a*x^2] + (1/5)*x^5*PolyLog[3, a*x^2]}
{x^2*PolyLog[3, a*x^2], x, 6, (8*x)/(27*a) + (8*x^3)/81 - (8*ArcTanh[Sqrt[a]*x])/(27*a^(3/2)) - (4/27)*x^3*Log[1 - a*x^2] - (2/9)*x^3*PolyLog[2, a*x^2] + (1/3)*x^3*PolyLog[3, a*x^2]}
{x^0*PolyLog[3, a*x^2], x, 5, 8*x - (8*ArcTanh[Sqrt[a]*x])/Sqrt[a] - 4*x*Log[1 - a*x^2] - 2*x*PolyLog[2, a*x^2] + x*PolyLog[3, a*x^2]}
{PolyLog[3, a*x^2]/x^2, x, 4, 8*Sqrt[a]*ArcTanh[Sqrt[a]*x] + (4*Log[1 - a*x^2])/x - (2*PolyLog[2, a*x^2])/x - PolyLog[3, a*x^2]/x}
{PolyLog[3, a*x^2]/x^4, x, 5, -((8*a)/(27*x)) + (8/27)*a^(3/2)*ArcTanh[Sqrt[a]*x] + (4*Log[1 - a*x^2])/(27*x^3) - (2*PolyLog[2, a*x^2])/(9*x^3) - PolyLog[3, a*x^2]/(3*x^3)}
{PolyLog[3, a*x^2]/x^6, x, 6, -((8*a)/(375*x^3)) - (8*a^2)/(125*x) + (8/125)*a^(5/2)*ArcTanh[Sqrt[a]*x] + (4*Log[1 - a*x^2])/(125*x^5) - (2*PolyLog[2, a*x^2])/(25*x^5) - PolyLog[3, a*x^2]/(5*x^5)}


(* ::Subsubsection::Closed:: *)
(*q symbolic*)


{x^2*PolyLog[2, a*x^q], x, 3, (a*q^2*x^(3 + q)*Hypergeometric2F1[1, (3 + q)/q, 2 + 3/q, a*x^q])/(9*(3 + q)) + (1/9)*q*x^3*Log[1 - a*x^q] + (1/3)*x^3*PolyLog[2, a*x^q]}
{x^1*PolyLog[2, a*x^q], x, 3, (a*q^2*x^(2 + q)*Hypergeometric2F1[1, (2 + q)/q, 2*(1 + 1/q), a*x^q])/(4*(2 + q)) + (1/4)*q*x^2*Log[1 - a*x^q] + (1/2)*x^2*PolyLog[2, a*x^q]}
{x^0*PolyLog[2, a*x^q], x, 3, (a*q^2*x^(1 + q)*Hypergeometric2F1[1, 1 + 1/q, 2 + 1/q, a*x^q])/(1 + q) + q*x*Log[1 - a*x^q] + x*PolyLog[2, a*x^q]}
{PolyLog[2, a*x^q]/x^1, x, 1, PolyLog[3, a*x^q]/q}
{PolyLog[2, a*x^q]/x^2, x, 3, -((a*q^2*x^(-1 + q)*Hypergeometric2F1[1, -((1 - q)/q), 2 - 1/q, a*x^q])/(1 - q)) + (q*Log[1 - a*x^q])/x - PolyLog[2, a*x^q]/x}
{PolyLog[2, a*x^q]/x^3, x, 3, -((a*q^2*x^(-2 + q)*Hypergeometric2F1[1, -((2 - q)/q), 2*(1 - 1/q), a*x^q])/(4*(2 - q))) + (q*Log[1 - a*x^q])/(4*x^2) - PolyLog[2, a*x^q]/(2*x^2)}
{PolyLog[2, a*x^q]/x^4, x, 3, -((a*q^2*x^(-3 + q)*Hypergeometric2F1[1, -((3 - q)/q), 2 - 3/q, a*x^q])/(9*(3 - q))) + (q*Log[1 - a*x^q])/(9*x^3) - PolyLog[2, a*x^q]/(3*x^3)}


{x^2*PolyLog[3, a*x^q], x, 4, -((a*q^3*x^(3 + q)*Hypergeometric2F1[1, (3 + q)/q, 2 + 3/q, a*x^q])/(27*(3 + q))) - (1/27)*q^2*x^3*Log[1 - a*x^q] - (1/9)*q*x^3*PolyLog[2, a*x^q] + (1/3)*x^3*PolyLog[3, a*x^q]}
{x^1*PolyLog[3, a*x^q], x, 4, -((a*q^3*x^(2 + q)*Hypergeometric2F1[1, (2 + q)/q, 2*(1 + 1/q), a*x^q])/(8*(2 + q))) - (1/8)*q^2*x^2*Log[1 - a*x^q] - (1/4)*q*x^2*PolyLog[2, a*x^q] + (1/2)*x^2*PolyLog[3, a*x^q]}
{x^0*PolyLog[3, a*x^q], x, 4, -((a*q^3*x^(1 + q)*Hypergeometric2F1[1, 1 + 1/q, 2 + 1/q, a*x^q])/(1 + q)) - q^2*x*Log[1 - a*x^q] - q*x*PolyLog[2, a*x^q] + x*PolyLog[3, a*x^q]}
{PolyLog[3, a*x^q]/x^1, x, 1, PolyLog[4, a*x^q]/q}
{PolyLog[3, a*x^q]/x^2, x, 4, -((a*q^3*x^(-1 + q)*Hypergeometric2F1[1, -((1 - q)/q), 2 - 1/q, a*x^q])/(1 - q)) + (q^2*Log[1 - a*x^q])/x - (q*PolyLog[2, a*x^q])/x - PolyLog[3, a*x^q]/x}
{PolyLog[3, a*x^q]/x^3, x, 4, -((a*q^3*x^(-2 + q)*Hypergeometric2F1[1, -((2 - q)/q), 2*(1 - 1/q), a*x^q])/(8*(2 - q))) + (q^2*Log[1 - a*x^q])/(8*x^2) - (q*PolyLog[2, a*x^q])/(4*x^2) - PolyLog[3, a*x^q]/(2*x^2)}
{PolyLog[3, a*x^q]/x^4, x, 4, -((a*q^3*x^(-3 + q)*Hypergeometric2F1[1, -((3 - q)/q), 2 - 3/q, a*x^q])/(27*(3 - q))) + (q^2*Log[1 - a*x^q])/(27*x^3) - (q*PolyLog[2, a*x^q])/(9*x^3) - PolyLog[3, a*x^q]/(3*x^3)}


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^(m/2) PolyLog[n, a x^q]*)


(* ::Subsubsection::Closed:: *)
(*q=1*)


{(d*x)^(3/2)*PolyLog[2, a*x], x, 7, -((8*d*Sqrt[d*x])/(25*a^2)) - (8*(d*x)^(3/2))/(75*a) - (8*(d*x)^(5/2))/(125*d) + (8*d^(3/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(25*a^(5/2)) + (4*(d*x)^(5/2)*Log[1 - a*x])/(25*d) + (2*(d*x)^(5/2)*PolyLog[2, a*x])/(5*d)}
{(d*x)^(1/2)*PolyLog[2, a*x], x, 6, -((8*Sqrt[d*x])/(9*a)) - (8*(d*x)^(3/2))/(27*d) + (8*Sqrt[d]*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(9*a^(3/2)) + (4*(d*x)^(3/2)*Log[1 - a*x])/(9*d) + (2*(d*x)^(3/2)*PolyLog[2, a*x])/(3*d)}
{PolyLog[2, a*x]/(d*x)^(1/2), x, 5, -((8*Sqrt[d*x])/d) + (8*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(Sqrt[a]*Sqrt[d]) + (4*Sqrt[d*x]*Log[1 - a*x])/d + (2*Sqrt[d*x]*PolyLog[2, a*x])/d}
{PolyLog[2, a*x]/(d*x)^(3/2), x, 4, (8*Sqrt[a]*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/d^(3/2) + (4*Log[1 - a*x])/(d*Sqrt[d*x]) - (2*PolyLog[2, a*x])/(d*Sqrt[d*x])}
{PolyLog[2, a*x]/(d*x)^(5/2), x, 5, -((8*a)/(9*d^2*Sqrt[d*x])) + (8*a^(3/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(9*d^(5/2)) + (4*Log[1 - a*x])/(9*d*(d*x)^(3/2)) - (2*PolyLog[2, a*x])/(3*d*(d*x)^(3/2))}
{PolyLog[2, a*x]/(d*x)^(7/2), x, 6, -((8*a)/(75*d^2*(d*x)^(3/2))) - (8*a^2)/(25*d^3*Sqrt[d*x]) + (8*a^(5/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(25*d^(7/2)) + (4*Log[1 - a*x])/(25*d*(d*x)^(5/2)) - (2*PolyLog[2, a*x])/(5*d*(d*x)^(5/2))}


{(d*x)^(5/2)*PolyLog[3, a*x], x, 9, (16*d^2*Sqrt[d*x])/(343*a^3) + (16*d*(d*x)^(3/2))/(1029*a^2) + (16*(d*x)^(5/2))/(1715*a) + (16*(d*x)^(7/2))/(2401*d) - (16*d^(5/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(343*a^(7/2)) - (8*(d*x)^(7/2)*Log[1 - a*x])/(343*d) - (4*(d*x)^(7/2)*PolyLog[2, a*x])/(49*d) + (2*(d*x)^(7/2)*PolyLog[3, a*x])/(7*d)}
{(d*x)^(3/2)*PolyLog[3, a*x], x, 8, (16*d*Sqrt[d*x])/(125*a^2) + (16*(d*x)^(3/2))/(375*a) + (16*(d*x)^(5/2))/(625*d) - (16*d^(3/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(125*a^(5/2)) - (8*(d*x)^(5/2)*Log[1 - a*x])/(125*d) - (4*(d*x)^(5/2)*PolyLog[2, a*x])/(25*d) + (2*(d*x)^(5/2)*PolyLog[3, a*x])/(5*d)}
{(d*x)^(1/2)*PolyLog[3, a*x], x, 7, (16*Sqrt[d*x])/(27*a) + (16*(d*x)^(3/2))/(81*d) - (16*Sqrt[d]*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(27*a^(3/2)) - (8*(d*x)^(3/2)*Log[1 - a*x])/(27*d) - (4*(d*x)^(3/2)*PolyLog[2, a*x])/(9*d) + (2*(d*x)^(3/2)*PolyLog[3, a*x])/(3*d)}
{PolyLog[3, a*x]/(d*x)^(1/2), x, 6, (16*Sqrt[d*x])/d - (16*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(Sqrt[a]*Sqrt[d]) - (8*Sqrt[d*x]*Log[1 - a*x])/d - (4*Sqrt[d*x]*PolyLog[2, a*x])/d + (2*Sqrt[d*x]*PolyLog[3, a*x])/d}
{PolyLog[3, a*x]/(d*x)^(3/2), x, 5, (16*Sqrt[a]*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/d^(3/2) + (8*Log[1 - a*x])/(d*Sqrt[d*x]) - (4*PolyLog[2, a*x])/(d*Sqrt[d*x]) - (2*PolyLog[3, a*x])/(d*Sqrt[d*x])}
{PolyLog[3, a*x]/(d*x)^(5/2), x, 6, -((16*a)/(27*d^2*Sqrt[d*x])) + (16*a^(3/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(27*d^(5/2)) + (8*Log[1 - a*x])/(27*d*(d*x)^(3/2)) - (4*PolyLog[2, a*x])/(9*d*(d*x)^(3/2)) - (2*PolyLog[3, a*x])/(3*d*(d*x)^(3/2))}
{PolyLog[3, a*x]/(d*x)^(7/2), x, 7, -((16*a)/(375*d^2*(d*x)^(3/2))) - (16*a^2)/(125*d^3*Sqrt[d*x]) + (16*a^(5/2)*ArcTanh[(Sqrt[a]*Sqrt[d*x])/Sqrt[d]])/(125*d^(7/2)) + (8*Log[1 - a*x])/(125*d*(d*x)^(5/2)) - (4*PolyLog[2, a*x])/(25*d*(d*x)^(5/2)) - (2*PolyLog[3, a*x])/(5*d*(d*x)^(5/2))}


(* ::Subsubsection::Closed:: *)
(*q=2*)


{(d*x)^(3/2)*PolyLog[2, a*x^2], x, 9, -((32*d*Sqrt[d*x])/(25*a)) - (32*(d*x)^(5/2))/(125*d) + (16*d^(3/2)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(25*a^(5/4)) + (16*d^(3/2)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(25*a^(5/4)) + (8*(d*x)^(5/2)*Log[1 - a*x^2])/(25*d) + (2*(d*x)^(5/2)*PolyLog[2, a*x^2])/(5*d)}
{(d*x)^(1/2)*PolyLog[2, a*x^2], x, 8, -((32*(d*x)^(3/2))/(27*d)) - (16*Sqrt[d]*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(9*a^(3/4)) + (16*Sqrt[d]*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(9*a^(3/4)) + (8*(d*x)^(3/2)*Log[1 - a*x^2])/(9*d) + (2*(d*x)^(3/2)*PolyLog[2, a*x^2])/(3*d)}
{PolyLog[2, a*x^2]/(d*x)^(1/2), x, 8, -((32*Sqrt[d*x])/d) + (16*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(a^(1/4)*Sqrt[d]) + (16*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(a^(1/4)*Sqrt[d]) + (8*Sqrt[d*x]*Log[1 - a*x^2])/d + (2*Sqrt[d*x]*PolyLog[2, a*x^2])/d}
{PolyLog[2, a*x^2]/(d*x)^(3/2), x, 7, -((16*a^(1/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/d^(3/2)) + (16*a^(1/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/d^(3/2) + (8*Log[1 - a*x^2])/(d*Sqrt[d*x]) - (2*PolyLog[2, a*x^2])/(d*Sqrt[d*x])}
{PolyLog[2, a*x^2]/(d*x)^(5/2), x, 7, (16*a^(3/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(9*d^(5/2)) + (16*a^(3/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(9*d^(5/2)) + (8*Log[1 - a*x^2])/(9*d*(d*x)^(3/2)) - (2*PolyLog[2, a*x^2])/(3*d*(d*x)^(3/2))}
{PolyLog[2, a*x^2]/(d*x)^(7/2), x, 8, -((32*a)/(25*d^3*Sqrt[d*x])) - (16*a^(5/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(25*d^(7/2)) + (16*a^(5/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(25*d^(7/2)) + (8*Log[1 - a*x^2])/(25*d*(d*x)^(5/2)) - (2*PolyLog[2, a*x^2])/(5*d*(d*x)^(5/2))}


{(d*x)^(5/2)*PolyLog[3, a*x^2], x, 10, (128*d*(d*x)^(3/2))/(1029*a) + (128*(d*x)^(7/2))/(2401*d) + (64*d^(5/2)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(343*a^(7/4)) - (64*d^(5/2)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(343*a^(7/4)) - (32*(d*x)^(7/2)*Log[1 - a*x^2])/(343*d) - (8*(d*x)^(7/2)*PolyLog[2, a*x^2])/(49*d) + (2*(d*x)^(7/2)*PolyLog[3, a*x^2])/(7*d)}
{(d*x)^(3/2)*PolyLog[3, a*x^2], x, 10, (128*d*Sqrt[d*x])/(125*a) + (128*(d*x)^(5/2))/(625*d) - (64*d^(3/2)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(125*a^(5/4)) - (64*d^(3/2)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(125*a^(5/4)) - (32*(d*x)^(5/2)*Log[1 - a*x^2])/(125*d) - (8*(d*x)^(5/2)*PolyLog[2, a*x^2])/(25*d) + (2*(d*x)^(5/2)*PolyLog[3, a*x^2])/(5*d)}
{(d*x)^(1/2)*PolyLog[3, a*x^2], x, 9, (128*(d*x)^(3/2))/(81*d) + (64*Sqrt[d]*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(27*a^(3/4)) - (64*Sqrt[d]*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(27*a^(3/4)) - (32*(d*x)^(3/2)*Log[1 - a*x^2])/(27*d) - (8*(d*x)^(3/2)*PolyLog[2, a*x^2])/(9*d) + (2*(d*x)^(3/2)*PolyLog[3, a*x^2])/(3*d)}
{PolyLog[3, a*x^2]/(d*x)^(1/2), x, 9, (128*Sqrt[d*x])/d - (64*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(a^(1/4)*Sqrt[d]) - (64*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(a^(1/4)*Sqrt[d]) - (32*Sqrt[d*x]*Log[1 - a*x^2])/d - (8*Sqrt[d*x]*PolyLog[2, a*x^2])/d + (2*Sqrt[d*x]*PolyLog[3, a*x^2])/d}
{PolyLog[3, a*x^2]/(d*x)^(3/2), x, 8, -((64*a^(1/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/d^(3/2)) + (64*a^(1/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/d^(3/2) + (32*Log[1 - a*x^2])/(d*Sqrt[d*x]) - (8*PolyLog[2, a*x^2])/(d*Sqrt[d*x]) - (2*PolyLog[3, a*x^2])/(d*Sqrt[d*x])}
{PolyLog[3, a*x^2]/(d*x)^(5/2), x, 8, (64*a^(3/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(27*d^(5/2)) + (64*a^(3/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(27*d^(5/2)) + (32*Log[1 - a*x^2])/(27*d*(d*x)^(3/2)) - (8*PolyLog[2, a*x^2])/(9*d*(d*x)^(3/2)) - (2*PolyLog[3, a*x^2])/(3*d*(d*x)^(3/2))}
{PolyLog[3, a*x^2]/(d*x)^(7/2), x, 9, -((128*a)/(125*d^3*Sqrt[d*x])) - (64*a^(5/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(125*d^(7/2)) + (64*a^(5/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(125*d^(7/2)) + (32*Log[1 - a*x^2])/(125*d*(d*x)^(5/2)) - (8*PolyLog[2, a*x^2])/(25*d*(d*x)^(5/2)) - (2*PolyLog[3, a*x^2])/(5*d*(d*x)^(5/2))}
{PolyLog[3, a*x^2]/(d*x)^(9/2), x, 9, -((128*a)/(1029*d^3*(d*x)^(3/2))) + (64*a^(7/4)*ArcTan[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(343*d^(9/2)) + (64*a^(7/4)*ArcTanh[(a^(1/4)*Sqrt[d*x])/Sqrt[d]])/(343*d^(9/2)) + (32*Log[1 - a*x^2])/(343*d*(d*x)^(7/2)) - (8*PolyLog[2, a*x^2])/(49*d*(d*x)^(7/2)) - (2*PolyLog[3, a*x^2])/(7*d*(d*x)^(7/2))}


(* ::Subsubsection::Closed:: *)
(*q symbolic*)


{(d*x)^(3/2)*PolyLog[2, a*x^q], x, 4, (8*a*d*q^2*x^(2 + q)*Sqrt[d*x]*Hypergeometric2F1[1, (5/2 + q)/q, (1/2)*(4 + 5/q), a*x^q])/(25*(5 + 2*q)) + (4*q*(d*x)^(5/2)*Log[1 - a*x^q])/(25*d) + (2*(d*x)^(5/2)*PolyLog[2, a*x^q])/(5*d)}
{(d*x)^(1/2)*PolyLog[2, a*x^q], x, 4, (8*a*q^2*x^(1 + q)*Sqrt[d*x]*Hypergeometric2F1[1, (3/2 + q)/q, (1/2)*(4 + 3/q), a*x^q])/(9*(3 + 2*q)) + (4*q*(d*x)^(3/2)*Log[1 - a*x^q])/(9*d) + (2*(d*x)^(3/2)*PolyLog[2, a*x^q])/(3*d)}
{PolyLog[2, a*x^q]/(d*x)^(1/2), x, 4, (8*a*q^2*x^q*Sqrt[d*x]*Hypergeometric2F1[1, (1/2 + q)/q, (1/2)*(4 + 1/q), a*x^q])/(d*(1 + 2*q)) + (4*q*Sqrt[d*x]*Log[1 - a*x^q])/d + (2*Sqrt[d*x]*PolyLog[2, a*x^q])/d}
{PolyLog[2, a*x^q]/(d*x)^(3/2), x, 4, -((8*a*q^2*x^q*Hypergeometric2F1[1, (1/2)*(2 - 1/q), (1/2)*(4 - 1/q), a*x^q])/(d*(1 - 2*q)*Sqrt[d*x])) + (4*q*Log[1 - a*x^q])/(d*Sqrt[d*x]) - (2*PolyLog[2, a*x^q])/(d*Sqrt[d*x])}
{PolyLog[2, a*x^q]/(d*x)^(5/2), x, 4, -((8*a*q^2*x^(-1 + q)*Hypergeometric2F1[1, (1/2)*(2 - 3/q), (1/2)*(4 - 3/q), a*x^q])/(9*d^2*(3 - 2*q)*Sqrt[d*x])) + (4*q*Log[1 - a*x^q])/(9*d*(d*x)^(3/2)) - (2*PolyLog[2, a*x^q])/(3*d*(d*x)^(3/2))}


{(d*x)^(3/2)*PolyLog[3, a*x^q], x, 5, -((16*a*d*q^3*x^(2 + q)*Sqrt[d*x]*Hypergeometric2F1[1, (5/2 + q)/q, (1/2)*(4 + 5/q), a*x^q])/(125*(5 + 2*q))) - (8*q^2*(d*x)^(5/2)*Log[1 - a*x^q])/(125*d) - (4*q*(d*x)^(5/2)*PolyLog[2, a*x^q])/(25*d) + (2*(d*x)^(5/2)*PolyLog[3, a*x^q])/(5*d)}
{(d*x)^(1/2)*PolyLog[3, a*x^q], x, 5, -((16*a*q^3*x^(1 + q)*Sqrt[d*x]*Hypergeometric2F1[1, (3/2 + q)/q, (1/2)*(4 + 3/q), a*x^q])/(27*(3 + 2*q))) - (8*q^2*(d*x)^(3/2)*Log[1 - a*x^q])/(27*d) - (4*q*(d*x)^(3/2)*PolyLog[2, a*x^q])/(9*d) + (2*(d*x)^(3/2)*PolyLog[3, a*x^q])/(3*d)}
{PolyLog[3, a*x^q]/(d*x)^(1/2), x, 5, -((16*a*q^3*x^q*Sqrt[d*x]*Hypergeometric2F1[1, (1/2 + q)/q, (1/2)*(4 + 1/q), a*x^q])/(d*(1 + 2*q))) - (8*q^2*Sqrt[d*x]*Log[1 - a*x^q])/d - (4*q*Sqrt[d*x]*PolyLog[2, a*x^q])/d + (2*Sqrt[d*x]*PolyLog[3, a*x^q])/d}
{PolyLog[3, a*x^q]/(d*x)^(3/2), x, 5, -((16*a*q^3*x^q*Hypergeometric2F1[1, (1/2)*(2 - 1/q), (1/2)*(4 - 1/q), a*x^q])/(d*(1 - 2*q)*Sqrt[d*x])) + (8*q^2*Log[1 - a*x^q])/(d*Sqrt[d*x]) - (4*q*PolyLog[2, a*x^q])/(d*Sqrt[d*x]) - (2*PolyLog[3, a*x^q])/(d*Sqrt[d*x])}
{PolyLog[3, a*x^q]/(d*x)^(5/2), x, 5, -((16*a*q^3*x^(-1 + q)*Hypergeometric2F1[1, (1/2)*(2 - 3/q), (1/2)*(4 - 3/q), a*x^q])/(27*d^2*(3 - 2*q)*Sqrt[d*x])) + (8*q^2*Log[1 - a*x^q])/(27*d*(d*x)^(3/2)) - (4*q*PolyLog[2, a*x^q])/(9*d*(d*x)^(3/2)) - (2*PolyLog[3, a*x^q])/(3*d*(d*x)^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m PolyLog[n/2, a x^q]*)


{PolyLog[3/2, a*x], x, 2, (-x)*PolyLog[1/2, a*x] + x*PolyLog[3/2, a*x] + Unintegrable[PolyLog[-(1/2), a*x], x]}
{PolyLog[1/2, a*x], x, 1, x*PolyLog[1/2, a*x] - Unintegrable[PolyLog[-(1/2), a*x], x]}
{PolyLog[-1/2, a*x], x, 0, Unintegrable[PolyLog[-(1/2), a*x], x]}
{PolyLog[-3/2, a*x], x, 1, x*PolyLog[-(1/2), a*x] - Unintegrable[PolyLog[-(1/2), a*x], x]}
{PolyLog[-5/2, a*x], x, 2, x*PolyLog[-(3/2), a*x] - x*PolyLog[-(1/2), a*x] + Unintegrable[PolyLog[-(1/2), a*x], x]}


{PolyLog[-3/2, a*x] + PolyLog[-1/2, a*x], x, 2, x*PolyLog[-1/2, a*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m PolyLog[n, a x^q] with m symbolic*)


{(d*x)^m*PolyLog[2, a*x], x, 3, (a*(d*x)^(2 + m)*Hypergeometric2F1[1, 2 + m, 3 + m, a*x])/(d^2*(1 + m)^2*(2 + m)) + ((d*x)^(1 + m)*Log[1 - a*x])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[2, a*x])/(d*(1 + m))}
{(d*x)^m*PolyLog[3, a*x], x, 4, -((a*(d*x)^(2 + m)*Hypergeometric2F1[1, 2 + m, 3 + m, a*x])/(d^2*(1 + m)^3*(2 + m))) - ((d*x)^(1 + m)*Log[1 - a*x])/(d*(1 + m)^3) - ((d*x)^(1 + m)*PolyLog[2, a*x])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[3, a*x])/(d*(1 + m))}
{(d*x)^m*PolyLog[4, a*x], x, 5, (a*(d*x)^(2 + m)*Hypergeometric2F1[1, 2 + m, 3 + m, a*x])/(d^2*(1 + m)^4*(2 + m)) + ((d*x)^(1 + m)*Log[1 - a*x])/(d*(1 + m)^4) + ((d*x)^(1 + m)*PolyLog[2, a*x])/(d*(1 + m)^3) - ((d*x)^(1 + m)*PolyLog[3, a*x])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[4, a*x])/(d*(1 + m))}


{(d*x)^m*PolyLog[2, a*x^2], x, 4, (4*a*(d*x)^(3 + m)*Hypergeometric2F1[1, (3 + m)/2, (5 + m)/2, a*x^2])/(d^3*(1 + m)^2*(3 + m)) + (2*(d*x)^(1 + m)*Log[1 - a*x^2])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[2, a*x^2])/(d*(1 + m))}
{(d*x)^m*PolyLog[3, a*x^2], x, 5, -((8*a*(d*x)^(3 + m)*Hypergeometric2F1[1, (3 + m)/2, (5 + m)/2, a*x^2])/(d^3*(1 + m)^3*(3 + m))) - (4*(d*x)^(1 + m)*Log[1 - a*x^2])/(d*(1 + m)^3) - (2*(d*x)^(1 + m)*PolyLog[2, a*x^2])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[3, a*x^2])/(d*(1 + m))}
{(d*x)^m*PolyLog[4, a*x^2], x, 6, (16*a*(d*x)^(3 + m)*Hypergeometric2F1[1, (3 + m)/2, (5 + m)/2, a*x^2])/(d^3*(1 + m)^4*(3 + m)) + (8*(d*x)^(1 + m)*Log[1 - a*x^2])/(d*(1 + m)^4) + (4*(d*x)^(1 + m)*PolyLog[2, a*x^2])/(d*(1 + m)^3) - (2*(d*x)^(1 + m)*PolyLog[3, a*x^2])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[4, a*x^2])/(d*(1 + m))}


{(d*x)^m*PolyLog[2, a*x^3], x, 4, (9*a*(d*x)^(4 + m)*Hypergeometric2F1[1, (4 + m)/3, (7 + m)/3, a*x^3])/(d^4*(1 + m)^2*(4 + m)) + (3*(d*x)^(1 + m)*Log[1 - a*x^3])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[2, a*x^3])/(d*(1 + m))}
{(d*x)^m*PolyLog[3, a*x^3], x, 5, -((27*a*(d*x)^(4 + m)*Hypergeometric2F1[1, (4 + m)/3, (7 + m)/3, a*x^3])/(d^4*(1 + m)^3*(4 + m))) - (9*(d*x)^(1 + m)*Log[1 - a*x^3])/(d*(1 + m)^3) - (3*(d*x)^(1 + m)*PolyLog[2, a*x^3])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[3, a*x^3])/(d*(1 + m))}
{(d*x)^m*PolyLog[4, a*x^3], x, 6, (81*a*(d*x)^(4 + m)*Hypergeometric2F1[1, (4 + m)/3, (7 + m)/3, a*x^3])/(d^4*(1 + m)^4*(4 + m)) + (27*(d*x)^(1 + m)*Log[1 - a*x^3])/(d*(1 + m)^4) + (9*(d*x)^(1 + m)*PolyLog[2, a*x^3])/(d*(1 + m)^3) - (3*(d*x)^(1 + m)*PolyLog[3, a*x^3])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[4, a*x^3])/(d*(1 + m))}


{(d*x)^m*PolyLog[2, a*x^q], x, 4, (a*q^2*x^(1 + q)*(d*x)^m*Hypergeometric2F1[1, (1 + m + q)/q, (1 + m + 2*q)/q, a*x^q])/((1 + m)^2*(1 + m + q)) + (q*(d*x)^(1 + m)*Log[1 - a*x^q])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[2, a*x^q])/(d*(1 + m))}
{(d*x)^m*PolyLog[3, a*x^q], x, 5, -((a*q^3*x^(1 + q)*(d*x)^m*Hypergeometric2F1[1, (1 + m + q)/q, (1 + m + 2*q)/q, a*x^q])/((1 + m)^3*(1 + m + q))) - (q^2*(d*x)^(1 + m)*Log[1 - a*x^q])/(d*(1 + m)^3) - (q*(d*x)^(1 + m)*PolyLog[2, a*x^q])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[3, a*x^q])/(d*(1 + m))}
{(d*x)^m*PolyLog[4, a*x^q], x, 6, (a*q^4*x^(1 + q)*(d*x)^m*Hypergeometric2F1[1, (1 + m + q)/q, (1 + m + 2*q)/q, a*x^q])/((1 + m)^4*(1 + m + q)) + (q^3*(d*x)^(1 + m)*Log[1 - a*x^q])/(d*(1 + m)^4) + (q^2*(d*x)^(1 + m)*PolyLog[2, a*x^q])/(d*(1 + m)^3) - (q*(d*x)^(1 + m)*PolyLog[3, a*x^q])/(d*(1 + m)^2) + ((d*x)^(1 + m)*PolyLog[4, a*x^q])/(d*(1 + m))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m PolyLog[n, a x^q] with n symbolic*)


{x^1*PolyLog[n, a*x], x, 0, Unintegrable[x*PolyLog[n, a*x], x]}
{x^0*PolyLog[n, a*x], x, 0, Unintegrable[PolyLog[n, a*x], x]}
{PolyLog[n, a*x]/x^1, x, 1, PolyLog[1 + n, a*x]}
{PolyLog[n, a*x]/x^2, x, 0, Unintegrable[PolyLog[n, a*x]/x^2, x]}
{PolyLog[n, a*x]/x^3, x, 0, Unintegrable[PolyLog[n, a*x]/x^3, x]}


{x^1*PolyLog[n, a*x^q], x, 0, Unintegrable[x*PolyLog[n, a*x^q], x]}
{x^0*PolyLog[n, a*x^q], x, 0, Unintegrable[PolyLog[n, a*x^q], x]}
{PolyLog[n, a*x^q]/x^1, x, 1, PolyLog[1 + n, a*x^q]/q}
{PolyLog[n, a*x^q]/x^2, x, 0, Unintegrable[PolyLog[n, a*x^q]/x^2, x]}
{PolyLog[n, a*x^q]/x^3, x, 0, Unintegrable[PolyLog[n, a*x^q]/x^3, x]}


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m PolyLog[n, c (a+b x)]*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m PolyLog[n, c (a+b x)]*)


{x^2*PolyLog[2, c*(a + b*x)], x, 13, -((a^2*x)/(3*b^2)) + (a*(1 - a*c)*x)/(6*b^2*c) - ((1 - a*c)^2*x)/(9*b^2*c^2) + (a*x^2)/(12*b) - ((1 - a*c)*x^2)/(18*b*c) - x^3/27 + (a*(1 - a*c)^2*Log[1 - a*c - b*c*x])/(6*b^3*c^2) - ((1 - a*c)^3*Log[1 - a*c - b*c*x])/(9*b^3*c^3) - (a*x^2*Log[1 - a*c - b*c*x])/(6*b) + (1/9)*x^3*Log[1 - a*c - b*c*x] - (a^2*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(3*b^3*c) + (a^3*PolyLog[2, c*(a + b*x)])/(3*b^3) + (1/3)*x^3*PolyLog[2, c*(a + b*x)]}
{x^1*PolyLog[2, c*(a + b*x)], x, 10, (a*x)/(2*b) - ((1 - a*c)*x)/(4*b*c) - x^2/8 - ((1 - a*c)^2*Log[1 - a*c - b*c*x])/(4*b^2*c^2) + (1/4)*x^2*Log[1 - a*c - b*c*x] + (a*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(2*b^2*c) - (a^2*PolyLog[2, c*(a + b*x)])/(2*b^2) + (1/2)*x^2*PolyLog[2, c*(a + b*x)]}
{x^0*PolyLog[2, c*(a + b*x)], x, 7, -x - ((1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(b*c) + (a*PolyLog[2, c*(a + b*x)])/b + x*PolyLog[2, c*(a + b*x)]}
{PolyLog[2, c*(a + b*x)]/x^1, x, 3, Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)] + (1/2)*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2 + (1/2)*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2 + (Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)] + Log[x]*PolyLog[2, c*(a + b*x)] + Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))] - Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))] + (Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)] - PolyLog[3, -((b*x)/a)] + PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))] - PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))] - PolyLog[3, 1 - c*(a + b*x)]}
{PolyLog[2, c*(a + b*x)]/x^2, x, 7, -((b*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/a) - (b*PolyLog[2, c*(a + b*x)])/a - PolyLog[2, c*(a + b*x)]/x - (b*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/a}
{PolyLog[2, c*(a + b*x)]/x^3, x, 11, (b^2*c*Log[x])/(2*a*(1 - a*c)) - (b^2*c*Log[1 - a*c - b*c*x])/(2*a*(1 - a*c)) + (b*Log[1 - a*c - b*c*x])/(2*a*x) + (b^2*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(2*a^2) + (b^2*PolyLog[2, c*(a + b*x)])/(2*a^2) - PolyLog[2, c*(a + b*x)]/(2*x^2) + (b^2*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2)}
{PolyLog[2, c*(a + b*x)]/x^4, x, 14, -((b^2*c)/(6*a*(1 - a*c)*x)) + (b^3*c^2*Log[x])/(6*a*(1 - a*c)^2) - (b^3*c*Log[x])/(3*a^2*(1 - a*c)) - (b^3*c^2*Log[1 - a*c - b*c*x])/(6*a*(1 - a*c)^2) + (b^3*c*Log[1 - a*c - b*c*x])/(3*a^2*(1 - a*c)) + (b*Log[1 - a*c - b*c*x])/(6*a*x^2) - (b^2*Log[1 - a*c - b*c*x])/(3*a^2*x) - (b^3*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(3*a^3) - (b^3*PolyLog[2, c*(a + b*x)])/(3*a^3) - PolyLog[2, c*(a + b*x)]/(3*x^3) - (b^3*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(3*a^3)}


{x^2*PolyLog[3, c*(a + b*x)], x, 33, (11*a^2*x)/(18*b^2) - (5*a*(1 - a*c)*x)/(36*b^2*c) + ((1 - a*c)^2*x)/(27*b^2*c^2) - (5*a*x^2)/(72*b) + ((1 - a*c)*x^2)/(54*b*c) + x^3/81 - (5*a*(1 - a*c)^2*Log[1 - a*c - b*c*x])/(36*b^3*c^2) + ((1 - a*c)^3*Log[1 - a*c - b*c*x])/(27*b^3*c^3) + (5*a*x^2*Log[1 - a*c - b*c*x])/(36*b) - (1/27)*x^3*Log[1 - a*c - b*c*x] + (11*a^2*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(18*b^3*c) - (11*a^3*PolyLog[2, c*(a + b*x)])/(18*b^3) - (a^2*x*PolyLog[2, c*(a + b*x)])/(3*b^2) + (a*x^2*PolyLog[2, c*(a + b*x)])/(6*b) - (1/9)*x^3*PolyLog[2, c*(a + b*x)] + (2*a^3*PolyLog[3, c*(a + b*x)])/(3*b^3) - ((a^3 - b^3*x^3)*PolyLog[3, c*(a + b*x)])/(3*b^3)}
{x^1*PolyLog[3, c*(a + b*x)], x, 19, -((3*a*x)/(4*b)) + ((1 - a*c)*x)/(8*b*c) + x^2/16 + ((1 - a*c)^2*Log[1 - a*c - b*c*x])/(8*b^2*c^2) - (1/8)*x^2*Log[1 - a*c - b*c*x] - (3*a*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(4*b^2*c) + (3*a^2*PolyLog[2, c*(a + b*x)])/(4*b^2) + (a*x*PolyLog[2, c*(a + b*x)])/(2*b) - (1/4)*x^2*PolyLog[2, c*(a + b*x)] - ((a^2 - b^2*x^2)*PolyLog[3, c*(a + b*x)])/(2*b^2)}
{x^0*PolyLog[3, c*(a + b*x)], x, 9, x + ((1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(b*c) - (a*PolyLog[2, c*(a + b*x)])/b - x*PolyLog[2, c*(a + b*x)] + (a*PolyLog[3, c*(a + b*x)])/b + x*PolyLog[3, c*(a + b*x)]}
{PolyLog[3, c*(a + b*x)]/x^1, x, 1, Int[PolyLog[3, a*c + b*c*x]/x, x]}
{PolyLog[3, c*(a + b*x)]/x^2, x, 6, (b*Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)])/a + (b*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2)/(2*a) + (b*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2)/(2*a) + (b*(Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)])/a + (b*Log[x]*PolyLog[2, c*(a + b*x)])/a + (b*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))])/a - (b*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))])/a + (b*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)])/a - (b*PolyLog[3, -((b*x)/a)])/a - (2*b*PolyLog[3, c*(a + b*x)])/a + ((b - a/x)*PolyLog[3, c*(a + b*x)])/a + (b*PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))])/a - (b*PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))])/a - (b*PolyLog[3, 1 - c*(a + b*x)])/a}
{PolyLog[3, c*(a + b*x)]/x^3, x, 12, -((b^2*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(2*a^2)) - (b^2*Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)])/(2*a^2) - (b^2*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2)/(4*a^2) - (b^2*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2)/(4*a^2) - (b^2*(Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)])/(2*a^2) - (b^2*PolyLog[2, c*(a + b*x)])/(2*a^2) - (b*PolyLog[2, c*(a + b*x)])/(2*a*x) - (b^2*Log[x]*PolyLog[2, c*(a + b*x)])/(2*a^2) - (b^2*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2) - (b^2*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))])/(2*a^2) + (b^2*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))])/(2*a^2) - (b^2*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)])/(2*a^2) + (b^2*PolyLog[3, -((b*x)/a)])/(2*a^2) + ((b^2 - a^2/x^2)*PolyLog[3, c*(a + b*x)])/(2*a^2) - (b^2*PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))])/(2*a^2) + (b^2*PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))])/(2*a^2) + (b^2*PolyLog[3, 1 - c*(a + b*x)])/(2*a^2)}


(* ::Subsection::Closed:: *)
(*Integrands of the form (d+e x)^m PolyLog[n,c (a+b x)]*)


{PolyLog[2, c*(a + b*x)]*(d + e*x)^3, x, 16, -(((b*d - a*e)^3*x)/(4*b^3)) - ((b*d - a*e)^2*(b*c*d + e - a*c*e)*x)/(8*b^3*c) - ((b*d - a*e)*(b*c*d + e - a*c*e)^2*x)/(12*b^3*c^2) - ((b*c*d + e - a*c*e)^3*x)/(16*b^3*c^3) - ((b*d - a*e)^2*(d + e*x)^2)/(16*b^2*e) - ((b*d - a*e)*(b*c*d + e - a*c*e)*(d + e*x)^2)/(24*b^2*c*e) - ((b*c*d + e - a*c*e)^2*(d + e*x)^2)/(32*b^2*c^2*e) - ((b*d - a*e)*(d + e*x)^3)/(36*b*e) - ((b*c*d + e - a*c*e)*(d + e*x)^3)/(48*b*c*e) - (d + e*x)^4/(64*e) - ((b*d - a*e)^2*(b*c*d + e - a*c*e)^2*Log[1 - a*c - b*c*x])/(8*b^4*c^2*e) - ((b*d - a*e)*(b*c*d + e - a*c*e)^3*Log[1 - a*c - b*c*x])/(12*b^4*c^3*e) - ((b*c*d + e - a*c*e)^4*Log[1 - a*c - b*c*x])/(16*b^4*c^4*e) - ((b*d - a*e)^3*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(4*b^4*c) + ((b*d - a*e)^2*(d + e*x)^2*Log[1 - a*c - b*c*x])/(8*b^2*e) + ((b*d - a*e)*(d + e*x)^3*Log[1 - a*c - b*c*x])/(12*b*e) + ((d + e*x)^4*Log[1 - a*c - b*c*x])/(16*e) - ((b*d - a*e)^4*PolyLog[2, c*(a + b*x)])/(4*b^4*e) + ((d + e*x)^4*PolyLog[2, c*(a + b*x)])/(4*e)}
{PolyLog[2, c*(a + b*x)]*(d + e*x)^2, x, 13, -(((b*d - a*e)^2*x)/(3*b^2)) - ((b*d - a*e)*(b*c*d + e - a*c*e)*x)/(6*b^2*c) - ((b*c*d + e - a*c*e)^2*x)/(9*b^2*c^2) - ((b*d - a*e)*(d + e*x)^2)/(12*b*e) - ((b*c*d + e - a*c*e)*(d + e*x)^2)/(18*b*c*e) - (d + e*x)^3/(27*e) - ((b*d - a*e)*(b*c*d + e - a*c*e)^2*Log[1 - a*c - b*c*x])/(6*b^3*c^2*e) - ((b*c*d + e - a*c*e)^3*Log[1 - a*c - b*c*x])/(9*b^3*c^3*e) - ((b*d - a*e)^2*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(3*b^3*c) + ((b*d - a*e)*(d + e*x)^2*Log[1 - a*c - b*c*x])/(6*b*e) + ((d + e*x)^3*Log[1 - a*c - b*c*x])/(9*e) - ((b*d - a*e)^3*PolyLog[2, c*(a + b*x)])/(3*b^3*e) + ((d + e*x)^3*PolyLog[2, c*(a + b*x)])/(3*e)}
{PolyLog[2, c*(a + b*x)]*(d + e*x)^1, x, 10, -(((b*d - a*e)*x)/(2*b)) - ((b*c*d + e - a*c*e)*x)/(4*b*c) - (d + e*x)^2/(8*e) - ((b*c*d + e - a*c*e)^2*Log[1 - a*c - b*c*x])/(4*b^2*c^2*e) - ((b*d - a*e)*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(2*b^2*c) + ((d + e*x)^2*Log[1 - a*c - b*c*x])/(4*e) - ((b*d - a*e)^2*PolyLog[2, c*(a + b*x)])/(2*b^2*e) + ((d + e*x)^2*PolyLog[2, c*(a + b*x)])/(2*e)}
{PolyLog[2, c*(a + b*x)]*(d + e*x)^0, x, 7, -x - ((1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(b*c) + (a*PolyLog[2, c*(a + b*x)])/b + x*PolyLog[2, c*(a + b*x)]}
{PolyLog[2, c*(a + b*x)]/(d + e*x)^1, x, 3, ((Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(2*e) + (Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/e - ((Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(2*e) + (Log[d + e*x]*PolyLog[2, c*(a + b*x)])/e + ((Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/e + ((Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/e - (Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/e + (Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/e - PolyLog[3, (b*(d + e*x))/(b*d - a*e)]/e - PolyLog[3, 1 - c*(a + b*x)]/e - PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))]/e + PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))]/e}
{PolyLog[2, c*(a + b*x)]/(d + e*x)^2, x, 8, (b*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(e*(b*d - a*e)) + (b*PolyLog[2, c*(a + b*x)])/(e*(b*d - a*e)) - PolyLog[2, c*(a + b*x)]/(e*(d + e*x)) + (b*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(e*(b*d - a*e))}
{PolyLog[2, c*(a + b*x)]/(d + e*x)^3, x, 12, (b^2*c*Log[1 - a*c - b*c*x])/(2*e*(b*d - a*e)*(b*c*d + e - a*c*e)) - (b*Log[1 - a*c - b*c*x])/(2*e*(b*d - a*e)*(d + e*x)) - (b^2*c*Log[d + e*x])/(2*e*(b*d - a*e)*(b*c*d + e - a*c*e)) + (b^2*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(2*e*(b*d - a*e)^2) + (b^2*PolyLog[2, c*(a + b*x)])/(2*e*(b*d - a*e)^2) - PolyLog[2, c*(a + b*x)]/(2*e*(d + e*x)^2) + (b^2*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(2*e*(b*d - a*e)^2)}
{PolyLog[2, c*(a + b*x)]/(d + e*x)^4, x, 15, (b^2*c)/(6*e*(b*d - a*e)*(b*c*d + e - a*c*e)*(d + e*x)) + (b^3*c^2*Log[1 - a*c - b*c*x])/(6*e*(b*d - a*e)*(b*c*d + e - a*c*e)^2) + (b^3*c*Log[1 - a*c - b*c*x])/(3*e*(b*d - a*e)^2*(b*c*d + e - a*c*e)) - (b*Log[1 - a*c - b*c*x])/(6*e*(b*d - a*e)*(d + e*x)^2) - (b^2*Log[1 - a*c - b*c*x])/(3*e*(b*d - a*e)^2*(d + e*x)) - (b^3*c^2*Log[d + e*x])/(6*e*(b*d - a*e)*(b*c*d + e - a*c*e)^2) - (b^3*c*Log[d + e*x])/(3*e*(b*d - a*e)^2*(b*c*d + e - a*c*e)) + (b^3*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(3*e*(b*d - a*e)^3) + (b^3*PolyLog[2, c*(a + b*x)])/(3*e*(b*d - a*e)^3) - PolyLog[2, c*(a + b*x)]/(3*e*(d + e*x)^3) + (b^3*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(3*e*(b*d - a*e)^3)}


(* Following integrands are equal. *)
{PolyLog[2, x]/(-1 + x), x, 5, Log[1-x]^2 Log[x]+2 Log[1-x] PolyLog[2,1-x]+Log[1-x] PolyLog[2,x]-2 PolyLog[3,1-x]}
{-PolyLog[2, x]/(1 - x), x, 5, Log[1-x]^2 Log[x]+2 Log[1-x] PolyLog[2,1-x]+Log[1-x] PolyLog[2,x]-2 PolyLog[3,1-x]}

{PolyLog[2, x]/((-1 + x)*x), x, 8, Log[1-x]^2 Log[x]+2 Log[1-x] PolyLog[2,1-x]+Log[1-x] PolyLog[2,x]-2 PolyLog[3,1-x]-PolyLog[3,x]}
{-PolyLog[2, x]/((1 - x)*x), x, 8, Log[1-x]^2 Log[x]+2 Log[1-x] PolyLog[2,1-x]+Log[1-x] PolyLog[2,x]-2 PolyLog[3,1-x]-PolyLog[3,x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form PolyLog[n, e ((a + b x) / (c + d x))^n] / ((a + b x) (c + d x))*)


{PolyLog[n, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 1, PolyLog[1 + n, e*((a + b*x)/(c + d*x))^n]/((b*c - a*d)*n)}


{PolyLog[3, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 1, PolyLog[4, e*((a + b*x)/(c + d*x))^n]/(n*(b*c - a*d))}
{PolyLog[2, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 1, PolyLog[3, e*((a + b*x)/(c + d*x))^n]/(n*(b*c - a*d))}
{PolyLog[1, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 1, PolyLog[2, e*((a + b*x)/(c + d*x))^n]/(n*(b*c - a*d))}
{PolyLog[0, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 2, PolyLog[1, e*((a + b*x)/(c + d*x))^n]/(n*(b*c - a*d))}
{PolyLog[-1, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 2, 1/((b*c - a*d)*n*(1 - e*((a + b*x)/(c + d*x))^n))}
{PolyLog[-2, e*((a + b*x)/(c + d*x))^n]/((a + b*x)*(c + d*x)), x, 4, PolyLog[-1, e*((a + b*x)/(c + d*x))^n]/(n*(b*c - a*d))}


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m PolyLog[n, d (F^(c (a + b x)))^p]*)


{x^3*PolyLog[n, d*(F^(c*(a + b*x)))^p], x, 5, (x^3*PolyLog[1 + n, d*(F^(c*(a + b*x)))^p])/(b*c*p*Log[F]) - (3*x^2*PolyLog[2 + n, d*(F^(c*(a + b*x)))^p])/(b^2*c^2*p^2*Log[F]^2) + (6*x*PolyLog[3 + n, d*(F^(c*(a + b*x)))^p])/(b^3*c^3*p^3*Log[F]^3) - (6*PolyLog[4 + n, d*(F^(c*(a + b*x)))^p])/(b^4*c^4*p^4*Log[F]^4)}
{x^2*PolyLog[n, d*(F^(c*(a + b*x)))^p], x, 4, (x^2*PolyLog[1 + n, d*(F^(c*(a + b*x)))^p])/(b*c*p*Log[F]) - (2*x*PolyLog[2 + n, d*(F^(c*(a + b*x)))^p])/(b^2*c^2*p^2*Log[F]^2) + (2*PolyLog[3 + n, d*(F^(c*(a + b*x)))^p])/(b^3*c^3*p^3*Log[F]^3)}
{x^1*PolyLog[n, d*(F^(c*(a + b*x)))^p], x, 3, (x*PolyLog[1 + n, d*(F^(c*(a + b*x)))^p])/(b*c*p*Log[F]) - PolyLog[2 + n, d*(F^(c*(a + b*x)))^p]/(b^2*c^2*p^2*Log[F]^2)}
{x^0*PolyLog[n, d*(F^(c*(a + b*x)))^p], x, 2, PolyLog[1 + n, d*(F^(c*(a + b*x)))^p]/(b*c*p*Log[F])}
{PolyLog[n, d*(F^(c*(a + b*x)))^p]/x^1, x, 1, CannotIntegrate[PolyLog[n, d*(F^(a*c + b*c*x))^p]/x, x]}


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m P[x] (g+h Log[f (d+e x)^n]) PolyLog[2, c (a+b x)]*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m Log[1-c x] PolyLog[2, c x]*)


{x^3*Log[1 - c*x]*PolyLog[2, c*x], x, 38, (355*x)/(576*c^3) + (139*x^2)/(1152*c^2) + (67*x^3)/(1728*c) + (3*x^4)/256 + (139*Log[1 - c*x])/(576*c^4) - (x^2*Log[1 - c*x])/(8*c^2) - (5*x^3*Log[1 - c*x])/(72*c) - (3/64)*x^4*Log[1 - c*x] + (3*(1 - c*x)*Log[1 - c*x])/(8*c^4) - Log[1 - c*x]^2/(16*c^4) + (1/16)*x^4*Log[1 - c*x]^2 - (Log[c*x]*Log[1 - c*x]^2)/(4*c^4) - (x*PolyLog[2, c*x])/(4*c^3) - (x^2*PolyLog[2, c*x])/(8*c^2) - (x^3*PolyLog[2, c*x])/(12*c) - (1/16)*x^4*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(4*c^4) + (1/4)*x^4*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, 1 - c*x])/(2*c^4) + PolyLog[3, 1 - c*x]/(2*c^4)}
{x^2*Log[1 - c*x]*PolyLog[2, c*x], x, 31, (31*x)/(36*c^2) + (11*x^2)/(72*c) + x^3/27 + (11*Log[1 - c*x])/(36*c^3) - (7*x^2*Log[1 - c*x])/(36*c) - (1/9)*x^3*Log[1 - c*x] + (5*(1 - c*x)*Log[1 - c*x])/(9*c^3) - Log[1 - c*x]^2/(9*c^3) + (1/9)*x^3*Log[1 - c*x]^2 - (Log[c*x]*Log[1 - c*x]^2)/(3*c^3) - (x*PolyLog[2, c*x])/(3*c^2) - (x^2*PolyLog[2, c*x])/(6*c) - (1/9)*x^3*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(3*c^3) + (1/3)*x^3*Log[1 - c*x]*PolyLog[2, c*x] - (2*Log[1 - c*x]*PolyLog[2, 1 - c*x])/(3*c^3) + (2*PolyLog[3, 1 - c*x])/(3*c^3)}
{x^1*Log[1 - c*x]*PolyLog[2, c*x], x, 22, (13*x)/(8*c) + x^2/16 + (1 - c*x)^2/(8*c^2) + Log[1 - c*x]/(8*c^2) - (1/8)*x^2*Log[1 - c*x] + (3*(1 - c*x)*Log[1 - c*x])/(2*c^2) - ((1 - c*x)^2*Log[1 - c*x])/(4*c^2) - ((1 - c*x)*Log[1 - c*x]^2)/(2*c^2) + ((1 - c*x)^2*Log[1 - c*x]^2)/(4*c^2) - (Log[c*x]*Log[1 - c*x]^2)/(2*c^2) - (x*PolyLog[2, c*x])/(2*c) - (1/4)*x^2*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(2*c^2) + (1/2)*x^2*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, 1 - c*x])/c^2 + PolyLog[3, 1 - c*x]/c^2}
{x^0*Log[1 - c*x]*PolyLog[2, c*x], x, 15, 3*x + (3*(1 - c*x)*Log[1 - c*x])/c - ((1 - c*x)*Log[1 - c*x]^2)/c - (Log[c*x]*Log[1 - c*x]^2)/c - x*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/c + x*Log[1 - c*x]*PolyLog[2, c*x] - (2*Log[1 - c*x]*PolyLog[2, 1 - c*x])/c + (2*PolyLog[3, 1 - c*x])/c}
{Log[1 - c*x]*PolyLog[2, c*x]/x^1, x, 1, (-(1/2))*PolyLog[2, c*x]^2}
{Log[1 - c*x]*PolyLog[2, c*x]/x^2, x, 10, ((1 - c*x)*Log[1 - c*x]^2)/x + c*Log[c*x]*Log[1 - c*x]^2 - 2*c*PolyLog[2, c*x] + c*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/x + 2*c*Log[1 - c*x]*PolyLog[2, 1 - c*x] - c*PolyLog[3, c*x] - 2*c*PolyLog[3, 1 - c*x]}
{Log[1 - c*x]*PolyLog[2, c*x]/x^3, x, 23, (-c^2)*Log[x] + c^2*Log[1 - c*x] - (c*Log[1 - c*x])/x - (1/4)*c^2*Log[1 - c*x]^2 + Log[1 - c*x]^2/(4*x^2) + (1/2)*c^2*Log[c*x]*Log[1 - c*x]^2 - (1/2)*c^2*PolyLog[2, c*x] + (c*PolyLog[2, c*x])/(2*x) + (1/2)*c^2*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(2*x^2) + c^2*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/2)*c^2*PolyLog[3, c*x] - c^2*PolyLog[3, 1 - c*x]}
{Log[1 - c*x]*PolyLog[2, c*x]/x^4, x, 30, (7*c^2)/(36*x) - (3/4)*c^3*Log[x] + (3/4)*c^3*Log[1 - c*x] - (7*c*Log[1 - c*x])/(36*x^2) - (5*c^2*Log[1 - c*x])/(9*x) - (1/9)*c^3*Log[1 - c*x]^2 + Log[1 - c*x]^2/(9*x^3) + (1/3)*c^3*Log[c*x]*Log[1 - c*x]^2 - (2/9)*c^3*PolyLog[2, c*x] + (c*PolyLog[2, c*x])/(6*x^2) + (c^2*PolyLog[2, c*x])/(3*x) + (1/3)*c^3*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(3*x^3) + (2/3)*c^3*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/3)*c^3*PolyLog[3, c*x] - (2/3)*c^3*PolyLog[3, 1 - c*x]}
{Log[1 - c*x]*PolyLog[2, c*x]/x^5, x, 37, (5*c^2)/(144*x^2) + (7*c^3)/(36*x) - (41/72)*c^4*Log[x] + (41/72)*c^4*Log[1 - c*x] - (5*c*Log[1 - c*x])/(72*x^3) - (c^2*Log[1 - c*x])/(8*x^2) - (3*c^3*Log[1 - c*x])/(8*x) - (1/16)*c^4*Log[1 - c*x]^2 + Log[1 - c*x]^2/(16*x^4) + (1/4)*c^4*Log[c*x]*Log[1 - c*x]^2 - (1/8)*c^4*PolyLog[2, c*x] + (c*PolyLog[2, c*x])/(12*x^3) + (c^2*PolyLog[2, c*x])/(8*x^2) + (c^3*PolyLog[2, c*x])/(4*x) + (1/4)*c^4*Log[1 - c*x]*PolyLog[2, c*x] - (Log[1 - c*x]*PolyLog[2, c*x])/(4*x^4) + (1/2)*c^4*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/4)*c^4*PolyLog[3, c*x] - (1/2)*c^4*PolyLog[3, 1 - c*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (g+h Log[1-c x]) PolyLog[2, c x]*)


{x^2*(g + h*Log[1 - c*x])*PolyLog[2, c*x], x, 25, (121*h*x)/(108*c^2) + (13*h*x^2)/(216*c) + (h*x^3)/81 + (h*(1 - c*x)^2)/(6*c^3) - (2*h*(1 - c*x)^3)/(81*c^3) + (13*h*Log[1 - c*x])/(108*c^3) - (h*x^2*Log[1 - c*x])/(12*c) - (1/27)*h*x^3*Log[1 - c*x] + (h*(1 - c*x)*Log[1 - c*x])/(3*c^3) + (h*Log[1 - c*x]^2)/(9*c^3) - (h*Log[c*x]*Log[1 - c*x]^2)/(3*c^3) + (1/9)*x^3*Log[1 - c*x]*(g + h*Log[1 - c*x]) + ((1 - c*x)*(g + 2*h*Log[1 - c*x]))/(3*c^3) - ((1 - c*x)^2*(g + 2*h*Log[1 - c*x]))/(6*c^3) + ((1 - c*x)^3*(g + 2*h*Log[1 - c*x]))/(27*c^3) - (Log[1 - c*x]*(g + 2*h*Log[1 - c*x]))/(9*c^3) - (h*x*PolyLog[2, c*x])/(3*c^2) - (h*x^2*PolyLog[2, c*x])/(6*c) - (1/9)*h*x^3*PolyLog[2, c*x] - (h*Log[1 - c*x]*PolyLog[2, c*x])/(3*c^3) + (1/3)*x^3*(g + h*Log[1 - c*x])*PolyLog[2, c*x] - (2*h*Log[1 - c*x]*PolyLog[2, 1 - c*x])/(3*c^3) + (2*h*PolyLog[3, 1 - c*x])/(3*c^3)}
{x^1*(g + h*Log[1 - c*x])*PolyLog[2, c*x], x, 21, (13*h*x)/(8*c) + (h*x^2)/16 + (h*(1 - c*x)^2)/(8*c^2) + (h*Log[1 - c*x])/(8*c^2) - (1/8)*h*x^2*Log[1 - c*x] + (h*(1 - c*x)*Log[1 - c*x])/(2*c^2) + (h*Log[1 - c*x]^2)/(4*c^2) - (h*Log[c*x]*Log[1 - c*x]^2)/(2*c^2) + (1/4)*x^2*Log[1 - c*x]*(g + h*Log[1 - c*x]) + ((1 - c*x)*(g + 2*h*Log[1 - c*x]))/(2*c^2) - ((1 - c*x)^2*(g + 2*h*Log[1 - c*x]))/(8*c^2) - (Log[1 - c*x]*(g + 2*h*Log[1 - c*x]))/(4*c^2) - (h*x*PolyLog[2, c*x])/(2*c) - (1/4)*h*x^2*PolyLog[2, c*x] - (h*Log[1 - c*x]*PolyLog[2, c*x])/(2*c^2) + (1/2)*x^2*(g + h*Log[1 - c*x])*PolyLog[2, c*x] - (h*Log[1 - c*x]*PolyLog[2, 1 - c*x])/c^2 + (h*PolyLog[3, 1 - c*x])/c^2}
{x^0*(g + h*Log[1 - c*x])*PolyLog[2, c*x], x, 18, (-g)*x + 3*h*x - (g*(1 - c*x)*Log[1 - c*x])/c + (3*h*(1 - c*x)*Log[1 - c*x])/c - (h*(1 - c*x)*Log[1 - c*x]^2)/c - (h*Log[c*x]*Log[1 - c*x]^2)/c - h*x*PolyLog[2, c*x] - (h*Log[1 - c*x]*PolyLog[2, c*x])/c + x*(g + h*Log[1 - c*x])*PolyLog[2, c*x] - (2*h*Log[1 - c*x]*PolyLog[2, 1 - c*x])/c + (2*h*PolyLog[3, 1 - c*x])/c}
{(g + h*Log[1 - c*x])*PolyLog[2, c*x]/x^1, x, 3, (-(1/2))*h*PolyLog[2, c*x]^2 + g*PolyLog[3, c*x]}
{(g + h*Log[1 - c*x])*PolyLog[2, c*x]/x^2, x, 12, c*h*Log[c*x]*Log[1 - c*x]^2 + (Log[1 - c*x]*(g + h*Log[1 - c*x]))/x + c*(g + 2*h*Log[1 - c*x])*Log[1 - 1/(1 - c*x)] + c*h*Log[1 - c*x]*PolyLog[2, c*x] - ((g + h*Log[1 - c*x])*PolyLog[2, c*x])/x - 2*c*h*PolyLog[2, 1/(1 - c*x)] + 2*c*h*Log[1 - c*x]*PolyLog[2, 1 - c*x] - c*h*PolyLog[3, c*x] - 2*c*h*PolyLog[3, 1 - c*x]}
{(g + h*Log[1 - c*x])*PolyLog[2, c*x]/x^3, x, 20, (-c^2)*h*Log[x] + (1/2)*c^2*h*Log[1 - c*x] - (c*h*Log[1 - c*x])/(2*x) + (1/2)*c^2*h*Log[c*x]*Log[1 - c*x]^2 + (Log[1 - c*x]*(g + h*Log[1 - c*x]))/(4*x^2) - (c*(1 - c*x)*(g + 2*h*Log[1 - c*x]))/(4*x) + (1/4)*c^2*(g + 2*h*Log[1 - c*x])*Log[1 - 1/(1 - c*x)] + (c*h*PolyLog[2, c*x])/(2*x) + (1/2)*c^2*h*Log[1 - c*x]*PolyLog[2, c*x] - ((g + h*Log[1 - c*x])*PolyLog[2, c*x])/(2*x^2) - (1/2)*c^2*h*PolyLog[2, 1/(1 - c*x)] + c^2*h*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/2)*c^2*h*PolyLog[3, c*x] - c^2*h*PolyLog[3, 1 - c*x]}
{(g + h*Log[1 - c*x])*PolyLog[2, c*x]/x^4, x, 28, (7*c^2*h)/(36*x) - (3/4)*c^3*h*Log[x] + (19/36)*c^3*h*Log[1 - c*x] - (c*h*Log[1 - c*x])/(12*x^2) - (c^2*h*Log[1 - c*x])/(3*x) + (1/3)*c^3*h*Log[c*x]*Log[1 - c*x]^2 + (Log[1 - c*x]*(g + h*Log[1 - c*x]))/(9*x^3) - (c*(g + 2*h*Log[1 - c*x]))/(18*x^2) - (c^2*(1 - c*x)*(g + 2*h*Log[1 - c*x]))/(9*x) + (1/9)*c^3*(g + 2*h*Log[1 - c*x])*Log[1 - 1/(1 - c*x)] + (c*h*PolyLog[2, c*x])/(6*x^2) + (c^2*h*PolyLog[2, c*x])/(3*x) + (1/3)*c^3*h*Log[1 - c*x]*PolyLog[2, c*x] - ((g + h*Log[1 - c*x])*PolyLog[2, c*x])/(3*x^3) - (2/9)*c^3*h*PolyLog[2, 1/(1 - c*x)] + (2/3)*c^3*h*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/3)*c^3*h*PolyLog[3, c*x] - (2/3)*c^3*h*PolyLog[3, 1 - c*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (g+h Log[f (d+e x)^n]) PolyLog[2, c (a+b x)]*)


{x^2*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)], x, 108, -((a^2*g*x)/(3*b^2)) + (a*(1 - a*c)*g*x)/(6*b^2*c) - ((1 - a*c)^2*g*x)/(9*b^2*c^2) + (7*a^2*h*n*x)/(9*b^2) - (11*a*(1 - a*c)*h*n*x)/(36*b^2*c) + (5*(1 - a*c)^2*h*n*x)/(27*b^2*c^2) + (13*d^2*h*n*x)/(27*e^2) + (5*a*d*h*n*x)/(12*b*e) - (7*(1 - a*c)*d*h*n*x)/(36*b*c*e) - (a*h*n*x^2)/(9*b) + (7*(1 - a*c)*h*n*x^2)/(108*b*c) - (19*d*h*n*x^2)/(216*e) + (1/27)*h*n*x^3 - (5*a*(1 - a*c)^2*h*n*Log[1 - a*c - b*c*x])/(36*b^3*c^2) + (2*(1 - a*c)^3*h*n*Log[1 - a*c - b*c*x])/(27*b^3*c^3) - (5*(1 - a*c)^2*d*h*n*Log[1 - a*c - b*c*x])/(36*b^2*c^2*e) + (5*a*h*n*x^2*Log[1 - a*c - b*c*x])/(36*b) + (5*d*h*n*x^2*Log[1 - a*c - b*c*x])/(36*e) - (2/27)*h*n*x^3*Log[1 - a*c - b*c*x] + (4*a^2*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(9*b^3*c) + (4*d^2*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(9*b*c*e^2) + (a*d*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(3*b^2*c*e) - (d^3*h*n*Log[d + e*x])/(27*e^3) - (a*d^2*h*n*Log[d + e*x])/(12*b*e^2) + ((1 - a*c)*d^2*h*n*Log[d + e*x])/(18*b*c*e^2) + (d^3*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(9*e^3) + (a*d^2*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(6*b*e^2) + (a^2*d*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(3*b^2*e) - (a^2*h*(d + e*x)*Log[f*(d + e*x)^n])/(3*b^2*e) + (a*(1 - a*c)*h*(d + e*x)*Log[f*(d + e*x)^n])/(6*b^2*c*e) - ((1 - a*c)^2*h*(d + e*x)*Log[f*(d + e*x)^n])/(9*b^2*c^2*e) + (a*x^2*(g + h*Log[f*(d + e*x)^n]))/(12*b) - ((1 - a*c)*x^2*(g + h*Log[f*(d + e*x)^n]))/(18*b*c) - (1/27)*x^3*(g + h*Log[f*(d + e*x)^n]) + (a^2*x*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(3*b^2) - (a*x^2*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(6*b) + (1/9)*x^3*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]) - (a^2*(1 - a*c)*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(3*b^3*c) + (a*(1 - a*c)^2*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(6*b^3*c^2) - ((1 - a*c)^3*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(9*b^3*c^3) - (a^3*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(6*b^3) + (d^3*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(6*e^3) - (a^3*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(3*b^3) + (d^3*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(3*e^3) + (a^3*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(6*b^3) - (d^3*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(6*e^3) + (a^3*g*PolyLog[2, c*(a + b*x)])/(3*b^3) - (a^3*h*n*PolyLog[2, c*(a + b*x)])/(9*b^3) - (a*d^2*h*n*PolyLog[2, c*(a + b*x)])/(3*b*e^2) - (a^2*d*h*n*PolyLog[2, c*(a + b*x)])/(6*b^2*e) - (d^2*h*n*x*PolyLog[2, c*(a + b*x)])/(3*e^2) + (d*h*n*x^2*PolyLog[2, c*(a + b*x)])/(6*e) - (1/9)*h*n*x^3*PolyLog[2, c*(a + b*x)] + (d^3*h*n*Log[d + e*x]*PolyLog[2, c*(a + b*x)])/(3*e^3) - (a^3*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(3*b^3) + (1/3)*x^3*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)] + (d^3*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(9*e^3) + (a*d^2*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(6*b*e^2) + (a^2*d*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(3*b^2*e) - (a^3*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(3*b^3) + (d^3*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(3*e^3) - (a^2*(1 - a*c)*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(3*b^3*c) + (a*(1 - a*c)^2*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(6*b^3*c^2) - ((1 - a*c)^3*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(9*b^3*c^3) - (a^3*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(3*b^3) + (d^3*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(3*e^3) + (a^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*b^3) - (d^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*e^3) - (a^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*b^3) + (d^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*e^3) + (a^3*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(3*b^3) - (d^3*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(3*e^3) + (a^3*h*n*PolyLog[3, 1 - c*(a + b*x)])/(3*b^3) - (d^3*h*n*PolyLog[3, 1 - c*(a + b*x)])/(3*e^3) + (a^3*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*b^3) - (d^3*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*e^3) - (a^3*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*b^3) + (d^3*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*e^3)}
{x^1*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)], x, 67, (a*g*x)/(2*b) - ((1 - a*c)*g*x)/(4*b*c) - (5*a*h*n*x)/(4*b) + ((1 - a*c)*h*n*x)/(2*b*c) - (7*d*h*n*x)/(8*e) + (3/16)*h*n*x^2 + ((1 - a*c)^2*h*n*Log[1 - a*c - b*c*x])/(4*b^2*c^2) - (1/4)*h*n*x^2*Log[1 - a*c - b*c*x] - (3*a*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(4*b^2*c) - (3*d*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(4*b*c*e) + (d^2*h*n*Log[d + e*x])/(8*e^2) - (d^2*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(4*e^2) - (a*d*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(2*b*e) + (a*h*(d + e*x)*Log[f*(d + e*x)^n])/(2*b*e) - ((1 - a*c)*h*(d + e*x)*Log[f*(d + e*x)^n])/(4*b*c*e) - (1/8)*x^2*(g + h*Log[f*(d + e*x)^n]) - (a*x*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(2*b) + (1/4)*x^2*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]) + (a*(1 - a*c)*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(2*b^2*c) - ((1 - a*c)^2*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(4*b^2*c^2) + (a^2*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(4*b^2) - (d^2*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(4*e^2) + (a^2*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(2*b^2) - (d^2*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(2*e^2) - (a^2*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(4*b^2) + (d^2*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(4*e^2) - (a^2*g*PolyLog[2, c*(a + b*x)])/(2*b^2) + (a^2*h*n*PolyLog[2, c*(a + b*x)])/(4*b^2) + (a*d*h*n*PolyLog[2, c*(a + b*x)])/(2*b*e) + (d*h*n*x*PolyLog[2, c*(a + b*x)])/(2*e) - (1/4)*h*n*x^2*PolyLog[2, c*(a + b*x)] - (d^2*h*n*Log[d + e*x]*PolyLog[2, c*(a + b*x)])/(2*e^2) + (a^2*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(2*b^2) + (1/2)*x^2*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)] - (d^2*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(4*e^2) - (a*d*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(2*b*e) + (a^2*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(2*b^2) - (d^2*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(2*e^2) + (a*(1 - a*c)*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(2*b^2*c) - ((1 - a*c)^2*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(4*b^2*c^2) + (a^2*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(2*b^2) - (d^2*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(2*e^2) - (a^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*b^2) + (d^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*e^2) + (a^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*b^2) - (d^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*e^2) - (a^2*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(2*b^2) + (d^2*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(2*e^2) - (a^2*h*n*PolyLog[3, 1 - c*(a + b*x)])/(2*b^2) + (d^2*h*n*PolyLog[3, 1 - c*(a + b*x)])/(2*e^2) - (a^2*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*b^2) + (d^2*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*e^2) + (a^2*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*b^2) - (d^2*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*e^2)}
{x^0*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)], x, 42, (-g)*x + 3*h*n*x - (g*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(b*c) + (2*h*n*(1 - a*c - b*c*x)*Log[1 - a*c - b*c*x])/(b*c) + (d*h*n*Log[c*(a + b*x)]*Log[1 - a*c - b*c*x]*Log[-d - e*x])/e + (d*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/e + (d*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))]^2)/(2*e) - (d*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[1 - a*c - b*c*x] + Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))])^2)/(2*e) - (h*(d + e*x)*Log[f*(d + e*x)^n])/e + h*x*Log[1 - a*c - b*c*x]*Log[f*(d + e*x)^n] - ((1 - a*c)*h*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*Log[f*(d + e*x)^n])/(b*c) - (a*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(2*b) - (a*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/b + (a*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(2*b) + (a*g*PolyLog[2, c*(a + b*x)])/b - (a*h*n*PolyLog[2, c*(a + b*x)])/b - (a*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/b + x*(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)] + (d*h*n*(Log[-d - e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))])*PolyLog[2, 1 - a*c - b*c*x])/e + (d*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/e - h*n*x*PolyLog[2, a*c + b*c*x] + (d*h*n*Log[-d - e*x]*PolyLog[2, a*c + b*c*x])/e - (d*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))]*PolyLog[2, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/e + (d*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))]*PolyLog[2, ((b*d - a*e)*(1 - a*c - b*c*x))/(b*(d + e*x))])/e + (d*h*n*(Log[1 - a*c - b*c*x] + Log[(b*(d + e*x))/((b*d - a*e)*(1 - a*c - b*c*x))])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/e - (a*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/b - ((1 - a*c)*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(b*c) - (a*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/b + (a*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/b - (a*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/b - (d*h*n*PolyLog[3, 1 - a*c - b*c*x])/e - (d*h*n*PolyLog[3, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/e + (d*h*n*PolyLog[3, ((b*d - a*e)*(1 - a*c - b*c*x))/(b*(d + e*x))])/e + (a*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/b - (d*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/e + (a*h*n*PolyLog[3, 1 - c*(a + b*x)])/b + (a*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/b - (a*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/b}
{(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)]/x^1, x, 0, Unintegrable[((g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/x, x]}
{(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)]/x^2, x, 22, -((b*g*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/a) - (b*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*Log[d + e*x])/a - (b*h*n*(Log[(b*c*x)/(1 - a*c)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*x)/((1 - a*c)*(d + e*x))])*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]^2)/(2*a) + (b*h*n*(Log[(b*c*x)/(1 - a*c)] - Log[-((e*x)/d)])*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])^2)/(2*a) + (b*h*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*(n*Log[d + e*x] - Log[f*(d + e*x)^n]))/a + (b*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(2*a) - (e*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(2*d) + (e*h*n*Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)])/d + (b*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/a - (e*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/d - (b*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(2*a) + (e*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(2*d) + (e*h*n*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2)/(2*d) + (e*h*n*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2)/(2*d) + (e*h*n*(Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)])/d - (b*g*PolyLog[2, c*(a + b*x)])/a + (e*h*n*Log[x]*PolyLog[2, c*(a + b*x)])/d - (e*h*n*Log[d + e*x]*PolyLog[2, c*(a + b*x)])/d + (b*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/a - ((g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/x - (b*g*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/a - (b*h*n*(Log[d + e*x] - Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/a + (b*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/a - (b*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/a + (b*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/a + (b*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/a - (e*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/d - (b*h*n*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 + (e*x)/d])/a + (e*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))])/d - (e*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))])/d + (b*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/a - (e*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/d + (e*h*n*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)])/d - (b*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/a + (e*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/d + (b*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/a - (e*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/d - (e*h*n*PolyLog[3, -((b*x)/a)])/d + (b*h*n*PolyLog[3, 1 - (b*c*x)/(1 - a*c)])/a - (b*h*n*PolyLog[3, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/a + (b*h*n*PolyLog[3, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/a - (b*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/a + (e*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/d + (b*h*n*PolyLog[3, 1 + (e*x)/d])/a + (e*h*n*PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))])/d - (e*h*n*PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))])/d - (b*h*n*PolyLog[3, 1 - c*(a + b*x)])/a - (b*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/a + (e*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/d + (b*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/a - (e*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/d}
{(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)]/x^3, x, 44, (b^2*g*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(2*a^2) - (b*e*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(a*d) + (b^2*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*Log[d + e*x])/(2*a^2) + (b*e*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(2*a*d) + (b^2*h*n*(Log[(b*c*x)/(1 - a*c)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*x)/((1 - a*c)*(d + e*x))])*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]^2)/(4*a^2) - (b^2*h*n*(Log[(b*c*x)/(1 - a*c)] - Log[-((e*x)/d)])*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])^2)/(4*a^2) - (b^2*h*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*(n*Log[d + e*x] - Log[f*(d + e*x)^n]))/(2*a^2) + (b^2*c*Log[-((e*x)/d)]*(g + h*Log[f*(d + e*x)^n]))/(2*a*(1 - a*c)) + (b*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(2*a*x) - (b^2*c*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(2*a*(1 - a*c)) - (b^2*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(4*a^2) + (e^2*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(4*d^2) - (e^2*h*n*Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)])/(2*d^2) - (b^2*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(2*a^2) + (e^2*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(2*d^2) + (b^2*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(4*a^2) - (e^2*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(4*d^2) - (e^2*h*n*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2)/(4*d^2) - (e^2*h*n*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2)/(4*d^2) - (e^2*h*n*(Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)])/(2*d^2) + (b^2*g*PolyLog[2, c*(a + b*x)])/(2*a^2) - (b*e*h*n*PolyLog[2, c*(a + b*x)])/(2*a*d) - (e*h*n*PolyLog[2, c*(a + b*x)])/(2*d*x) - (e^2*h*n*Log[x]*PolyLog[2, c*(a + b*x)])/(2*d^2) + (e^2*h*n*Log[d + e*x]*PolyLog[2, c*(a + b*x)])/(2*d^2) - (b^2*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(2*a^2) - ((g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(2*x^2) + (b*e*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(2*a*d) + (b^2*g*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2) - (b*e*h*n*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(a*d) + (b^2*h*n*(Log[d + e*x] - Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2) - (b^2*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2) + (b^2*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/(2*a^2) - (b^2*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/(2*a^2) - (b^2*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(2*a^2) + (e^2*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(2*d^2) - (b^2*c*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(2*a*(1 - a*c)) + (b^2*c*h*n*PolyLog[2, 1 + (e*x)/d])/(2*a*(1 - a*c)) + (b^2*h*n*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 + (e*x)/d])/(2*a^2) - (e^2*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))])/(2*d^2) + (e^2*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))])/(2*d^2) - (b^2*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(2*a^2) + (e^2*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(2*d^2) - (e^2*h*n*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)])/(2*d^2) + (b^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*a^2) - (e^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*d^2) - (b^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*a^2) + (e^2*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*d^2) + (e^2*h*n*PolyLog[3, -((b*x)/a)])/(2*d^2) - (b^2*h*n*PolyLog[3, 1 - (b*c*x)/(1 - a*c)])/(2*a^2) + (b^2*h*n*PolyLog[3, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/(2*a^2) - (b^2*h*n*PolyLog[3, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/(2*a^2) + (b^2*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(2*a^2) - (e^2*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(2*d^2) - (b^2*h*n*PolyLog[3, 1 + (e*x)/d])/(2*a^2) - (e^2*h*n*PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))])/(2*d^2) + (e^2*h*n*PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))])/(2*d^2) + (b^2*h*n*PolyLog[3, 1 - c*(a + b*x)])/(2*a^2) + (b^2*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*a^2) - (e^2*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(2*d^2) - (b^2*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*a^2) + (e^2*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(2*d^2)}
{(g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)]/x^4, x, 78, (b^2*c*e*h*n*Log[x])/(2*a*(1 - a*c)*d) - (b^2*c*e*h*n*Log[1 - a*c - b*c*x])/(3*a*(1 - a*c)*d) + (b*e*h*n*Log[1 - a*c - b*c*x])/(3*a*d*x) - (b^3*g*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(3*a^3) + (b^2*e*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(2*a^2*d) + (b*e^2*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x])/(2*a*d^2) - (b^2*c*e*h*n*Log[d + e*x])/(6*a*(1 - a*c)*d) - (b^3*h*n*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*Log[d + e*x])/(3*a^3) - (b^2*e*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(3*a^2*d) - (b*e^2*h*n*Log[1 - a*c - b*c*x]*Log[(b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(6*a*d^2) - (b^3*h*n*(Log[(b*c*x)/(1 - a*c)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*x)/((1 - a*c)*(d + e*x))])*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]^2)/(6*a^3) + (b^3*h*n*(Log[(b*c*x)/(1 - a*c)] - Log[-((e*x)/d)])*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])^2)/(6*a^3) + (b^3*h*Log[(b*c*x)/(1 - a*c)]*Log[1 - a*c - b*c*x]*(n*Log[d + e*x] - Log[f*(d + e*x)^n]))/(3*a^3) - (b^2*c*(g + h*Log[f*(d + e*x)^n]))/(6*a*(1 - a*c)*x) + (b^3*c^2*Log[-((e*x)/d)]*(g + h*Log[f*(d + e*x)^n]))/(6*a*(1 - a*c)^2) - (b^3*c*Log[-((e*x)/d)]*(g + h*Log[f*(d + e*x)^n]))/(3*a^2*(1 - a*c)) + (b*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(6*a*x^2) - (b^2*Log[1 - a*c - b*c*x]*(g + h*Log[f*(d + e*x)^n]))/(3*a^2*x) - (b^3*c^2*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(6*a*(1 - a*c)^2) + (b^3*c*Log[(e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)]*(g + h*Log[f*(d + e*x)^n]))/(3*a^2*(1 - a*c)) + (b^3*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(6*a^3) - (e^3*h*n*(Log[c*(a + b*x)] + Log[(b*c*d + e - a*c*e)/(b*c*(d + e*x))] - Log[((b*c*d + e - a*c*e)*(a + b*x))/(b*(d + e*x))])*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]^2)/(6*d^3) + (e^3*h*n*Log[x]*Log[1 + (b*x)/a]*Log[1 - c*(a + b*x)])/(3*d^3) + (b^3*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(3*a^3) - (e^3*h*n*Log[c*(a + b*x)]*Log[d + e*x]*Log[1 - c*(a + b*x)])/(3*d^3) - (b^3*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(6*a^3) + (e^3*h*n*(Log[c*(a + b*x)] - Log[-((e*(a + b*x))/(b*d - a*e))])*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])^2)/(6*d^3) + (e^3*h*n*(Log[1 + (b*x)/a] + Log[(1 - a*c)/(1 - c*(a + b*x))] - Log[((1 - a*c)*(a + b*x))/(a*(1 - c*(a + b*x)))])*Log[-((a*(1 - c*(a + b*x)))/(b*x))]^2)/(6*d^3) + (e^3*h*n*(Log[c*(a + b*x)] - Log[1 + (b*x)/a])*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])^2)/(6*d^3) + (e^3*h*n*(Log[1 - c*(a + b*x)] - Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, -((b*x)/a)])/(3*d^3) - (b^3*g*PolyLog[2, c*(a + b*x)])/(3*a^3) + (b^2*e*h*n*PolyLog[2, c*(a + b*x)])/(6*a^2*d) + (b*e^2*h*n*PolyLog[2, c*(a + b*x)])/(3*a*d^2) - (e*h*n*PolyLog[2, c*(a + b*x)])/(6*d*x^2) + (e^2*h*n*PolyLog[2, c*(a + b*x)])/(3*d^2*x) + (e^3*h*n*Log[x]*PolyLog[2, c*(a + b*x)])/(3*d^3) - (e^3*h*n*Log[d + e*x]*PolyLog[2, c*(a + b*x)])/(3*d^3) + (b^3*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(3*a^3) - ((g + h*Log[f*(d + e*x)^n])*PolyLog[2, c*(a + b*x)])/(3*x^3) - (b^2*e*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(3*a^2*d) - (b*e^2*h*n*PolyLog[2, (e*(1 - a*c - b*c*x))/(b*c*d + e - a*c*e)])/(6*a*d^2) - (b^3*g*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(3*a^3) + (b^2*e*h*n*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a^2*d) + (b*e^2*h*n*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(2*a*d^2) - (b^3*h*n*(Log[d + e*x] - Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(3*a^3) + (b^3*h*(n*Log[d + e*x] - Log[f*(d + e*x)^n])*PolyLog[2, 1 - (b*c*x)/(1 - a*c)])/(3*a^3) - (b^3*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/(3*a^3) + (b^3*h*n*Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))]*PolyLog[2, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/(3*a^3) + (b^3*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(3*a^3) - (e^3*h*n*(Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))] + Log[1 - c*(a + b*x)])*PolyLog[2, (b*(d + e*x))/(b*d - a*e)])/(3*d^3) - (b^3*c^2*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(6*a*(1 - a*c)^2) + (b^3*c*h*n*PolyLog[2, (b*c*(d + e*x))/(b*c*d + e - a*c*e)])/(3*a^2*(1 - a*c)) + (b^3*c^2*h*n*PolyLog[2, 1 + (e*x)/d])/(6*a*(1 - a*c)^2) - (b^3*c*h*n*PolyLog[2, 1 + (e*x)/d])/(3*a^2*(1 - a*c)) - (b^3*h*n*(Log[1 - a*c - b*c*x] + Log[((1 - a*c)*(d + e*x))/(d*(1 - a*c - b*c*x))])*PolyLog[2, 1 + (e*x)/d])/(3*a^3) + (e^3*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*x)/(a*(1 - c*(a + b*x))))])/(3*d^3) - (e^3*h*n*Log[-((a*(1 - c*(a + b*x)))/(b*x))]*PolyLog[2, -((b*c*x)/(1 - c*(a + b*x)))])/(3*d^3) + (b^3*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(3*a^3) - (e^3*h*n*(Log[d + e*x] - Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))])*PolyLog[2, 1 - c*(a + b*x)])/(3*d^3) + (e^3*h*n*(Log[x] + Log[-((a*(1 - c*(a + b*x)))/(b*x))])*PolyLog[2, 1 - c*(a + b*x)])/(3*d^3) - (b^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*a^3) + (e^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*d^3) + (b^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*a^3) - (e^3*h*n*Log[(b*(d + e*x))/((b*d - a*e)*(1 - c*(a + b*x)))]*PolyLog[2, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*d^3) - (e^3*h*n*PolyLog[3, -((b*x)/a)])/(3*d^3) + (b^3*h*n*PolyLog[3, 1 - (b*c*x)/(1 - a*c)])/(3*a^3) - (b^3*h*n*PolyLog[3, (d*(1 - a*c - b*c*x))/((1 - a*c)*(d + e*x))])/(3*a^3) + (b^3*h*n*PolyLog[3, -((e*(1 - a*c - b*c*x))/(b*c*(d + e*x)))])/(3*a^3) - (b^3*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(3*a^3) + (e^3*h*n*PolyLog[3, (b*(d + e*x))/(b*d - a*e)])/(3*d^3) + (b^3*h*n*PolyLog[3, 1 + (e*x)/d])/(3*a^3) + (e^3*h*n*PolyLog[3, -((b*x)/(a*(1 - c*(a + b*x))))])/(3*d^3) - (e^3*h*n*PolyLog[3, -((b*c*x)/(1 - c*(a + b*x)))])/(3*d^3) - (b^3*h*n*PolyLog[3, 1 - c*(a + b*x)])/(3*a^3) - (b^3*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*a^3) + (e^3*h*n*PolyLog[3, -((e*(1 - c*(a + b*x)))/(b*c*(d + e*x)))])/(3*d^3) + (b^3*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*a^3) - (e^3*h*n*PolyLog[3, ((b*d - a*e)*(1 - c*(a + b*x)))/(b*(d + e*x))])/(3*d^3)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x) Log[1-c x] PolyLog[2, c x]*)


{x^2*(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x], x, 52, (53*b*x)/(192*c^3) + (11*a*x)/(27*c^2) + (49*(3*b + 4*a*c)*x)/(432*c^3) + (29*b*x^2)/(384*c^2) + (5*a*x^2)/(54*c) + (13*(3*b + 4*a*c)*x^2)/(864*c^2) + (2*a*x^3)/81 + (17*b*x^3)/(576*c) + ((3*b + 4*a*c)*x^3)/(324*c) + (3*b*x^4)/256 + (29*b*Log[1 - c*x])/(192*c^4) + (5*a*Log[1 - c*x])/(27*c^3) + (13*(3*b + 4*a*c)*Log[1 - c*x])/(432*c^4) - (b*x^2*Log[1 - c*x])/(16*c^2) - (a*x^2*Log[1 - c*x])/(9*c) - ((3*b + 4*a*c)*x^2*Log[1 - c*x])/(48*c^2) - (2/27)*a*x^3*Log[1 - c*x] - (b*x^3*Log[1 - c*x])/(24*c) - ((3*b + 4*a*c)*x^3*Log[1 - c*x])/(108*c) - (3/64)*b*x^4*Log[1 - c*x] + (b*(1 - c*x)*Log[1 - c*x])/(8*c^4) + (2*a*(1 - c*x)*Log[1 - c*x])/(9*c^3) + ((3*b + 4*a*c)*(1 - c*x)*Log[1 - c*x])/(12*c^4) - (b*Log[1 - c*x]^2)/(16*c^4) - (a*Log[1 - c*x]^2)/(9*c^3) + (1/9)*a*x^3*Log[1 - c*x]^2 + (1/16)*b*x^4*Log[1 - c*x]^2 - ((3*b + 4*a*c)*Log[c*x]*Log[1 - c*x]^2)/(12*c^4) - ((3*b + 4*a*c)*x*PolyLog[2, c*x])/(12*c^3) - ((3*b + 4*a*c)*x^2*PolyLog[2, c*x])/(24*c^2) - ((3*b + 4*a*c)*x^3*PolyLog[2, c*x])/(36*c) - (1/16)*b*x^4*PolyLog[2, c*x] - ((3*b + 4*a*c)*Log[1 - c*x]*PolyLog[2, c*x])/(12*c^4) + (1/12)*(4*a*x^3 + 3*b*x^4)*Log[1 - c*x]*PolyLog[2, c*x] - ((3*b + 4*a*c)*Log[1 - c*x]*PolyLog[2, 1 - c*x])/(6*c^4) + ((3*b + 4*a*c)*PolyLog[3, 1 - c*x])/(6*c^4)}
{x^1*(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x], x, 40, (4*b*x)/(9*c^2) + (a*x)/c + (5*(2*b + 3*a*c)*x)/(24*c^2) + (b*x^2)/(9*c) + ((2*b + 3*a*c)*x^2)/(48*c) + (b*x^3)/27 + (a*(1 - c*x)^2)/(8*c^2) + (2*b*Log[1 - c*x])/(9*c^3) + ((2*b + 3*a*c)*Log[1 - c*x])/(24*c^3) - (b*x^2*Log[1 - c*x])/(9*c) - ((2*b + 3*a*c)*x^2*Log[1 - c*x])/(24*c) - (1/9)*b*x^3*Log[1 - c*x] + (2*b*(1 - c*x)*Log[1 - c*x])/(9*c^3) + (a*(1 - c*x)*Log[1 - c*x])/c^2 + ((2*b + 3*a*c)*(1 - c*x)*Log[1 - c*x])/(6*c^3) - (a*(1 - c*x)^2*Log[1 - c*x])/(4*c^2) - (b*Log[1 - c*x]^2)/(9*c^3) + (1/9)*b*x^3*Log[1 - c*x]^2 - (a*(1 - c*x)*Log[1 - c*x]^2)/(2*c^2) + (a*(1 - c*x)^2*Log[1 - c*x]^2)/(4*c^2) - ((2*b + 3*a*c)*Log[c*x]*Log[1 - c*x]^2)/(6*c^3) - ((2*b + 3*a*c)*x*PolyLog[2, c*x])/(6*c^2) - ((2*b + 3*a*c)*x^2*PolyLog[2, c*x])/(12*c) - (1/9)*b*x^3*PolyLog[2, c*x] - ((2*b + 3*a*c)*Log[1 - c*x]*PolyLog[2, c*x])/(6*c^3) + (1/6)*(3*a*x^2 + 2*b*x^3)*Log[1 - c*x]*PolyLog[2, c*x] - ((2*b + 3*a*c)*Log[1 - c*x]*PolyLog[2, 1 - c*x])/(3*c^3) + ((2*b + 3*a*c)*PolyLog[3, 1 - c*x])/(3*c^3)}
{x^0*(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x], x, 26, 2*a*x + (9*b*x)/(8*c) + ((b + 2*a*c)*x)/(2*c) + (b*x^2)/16 + (b*(1 - c*x)^2)/(8*c^2) + (b*Log[1 - c*x])/(8*c^2) - (1/8)*b*x^2*Log[1 - c*x] + (b*(1 - c*x)*Log[1 - c*x])/c^2 + (2*a*(1 - c*x)*Log[1 - c*x])/c + ((b + 2*a*c)*(1 - c*x)*Log[1 - c*x])/(2*c^2) - (b*(1 - c*x)^2*Log[1 - c*x])/(4*c^2) - (b*(1 - c*x)*Log[1 - c*x]^2)/(2*c^2) - (a*(1 - c*x)*Log[1 - c*x]^2)/c + (b*(1 - c*x)^2*Log[1 - c*x]^2)/(4*c^2) - ((b + 2*a*c)*Log[c*x]*Log[1 - c*x]^2)/(2*c^2) - ((b + 2*a*c)*x*PolyLog[2, c*x])/(2*c) - (1/4)*b*x^2*PolyLog[2, c*x] - ((b + 2*a*c)*Log[1 - c*x]*PolyLog[2, c*x])/(2*c^2) + (1/2)*(2*a*x + b*x^2)*Log[1 - c*x]*PolyLog[2, c*x] - ((b + 2*a*c)*Log[1 - c*x]*PolyLog[2, 1 - c*x])/c^2 + ((b + 2*a*c)*PolyLog[3, 1 - c*x])/c^2}
{(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x]/x^1, x, 18, 3*b*x + (3*b*(1 - c*x)*Log[1 - c*x])/c - (b*(1 - c*x)*Log[1 - c*x]^2)/c - (b*Log[c*x]*Log[1 - c*x]^2)/c - b*x*PolyLog[2, c*x] - (b*Log[1 - c*x]*PolyLog[2, c*x])/c + b*x*Log[1 - c*x]*PolyLog[2, c*x] - (1/2)*a*PolyLog[2, c*x]^2 - (2*b*Log[1 - c*x]*PolyLog[2, 1 - c*x])/c + (2*b*PolyLog[3, 1 - c*x])/c}
{(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x]/x^2, x, 13, (a*(1 - c*x)*Log[1 - c*x]^2)/x + a*c*Log[c*x]*Log[1 - c*x]^2 - 2*a*c*PolyLog[2, c*x] + a*c*Log[1 - c*x]*PolyLog[2, c*x] - (a*Log[1 - c*x]*PolyLog[2, c*x])/x - (1/2)*b*PolyLog[2, c*x]^2 + 2*a*c*Log[1 - c*x]*PolyLog[2, 1 - c*x] - a*c*PolyLog[3, c*x] - 2*a*c*PolyLog[3, 1 - c*x]}
{(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x]/x^3, x, 30, (-a)*c^2*Log[x] + a*c^2*Log[1 - c*x] - (a*c*Log[1 - c*x])/x - (1/4)*a*c^2*Log[1 - c*x]^2 + (a*Log[1 - c*x]^2)/(4*x^2) + (b*(1 - c*x)*Log[1 - c*x]^2)/x - (b^2*Log[c*x]*Log[1 - c*x]^2)/(2*a) + ((b + a*c)^2*Log[c*x]*Log[1 - c*x]^2)/(2*a) - 2*b*c*PolyLog[2, c*x] - (1/2)*a*c^2*PolyLog[2, c*x] + (a*c*PolyLog[2, c*x])/(2*x) + ((b + a*c)^2*Log[1 - c*x]*PolyLog[2, c*x])/(2*a) - ((a + b*x)^2*Log[1 - c*x]*PolyLog[2, c*x])/(2*a*x^2) - (b^2*Log[1 - c*x]*PolyLog[2, 1 - c*x])/a + ((b + a*c)^2*Log[1 - c*x]*PolyLog[2, 1 - c*x])/a - (1/2)*c*(2*b + a*c)*PolyLog[3, c*x] + (b^2*PolyLog[3, 1 - c*x])/a - ((b + a*c)^2*PolyLog[3, 1 - c*x])/a}
{(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x]/x^4, x, 41, (7*a*c^2)/(36*x) - (1/2)*b*c^2*Log[x] - (5/12)*a*c^3*Log[x] - (1/6)*c^2*(3*b + 2*a*c)*Log[x] + (1/2)*b*c^2*Log[1 - c*x] + (5/12)*a*c^3*Log[1 - c*x] + (1/6)*c^2*(3*b + 2*a*c)*Log[1 - c*x] - (7*a*c*Log[1 - c*x])/(36*x^2) - (b*c*Log[1 - c*x])/(2*x) - (2*a*c^2*Log[1 - c*x])/(9*x) - (c*(3*b + 2*a*c)*Log[1 - c*x])/(6*x) - (1/4)*b*c^2*Log[1 - c*x]^2 - (1/9)*a*c^3*Log[1 - c*x]^2 + (a*Log[1 - c*x]^2)/(9*x^3) + (b*Log[1 - c*x]^2)/(4*x^2) + (1/6)*c^2*(3*b + 2*a*c)*Log[c*x]*Log[1 - c*x]^2 - (1/2)*b*c^2*PolyLog[2, c*x] - (2/9)*a*c^3*PolyLog[2, c*x] + (a*c*PolyLog[2, c*x])/(6*x^2) + (c*(3*b + 2*a*c)*PolyLog[2, c*x])/(6*x) + (1/6)*c^2*(3*b + 2*a*c)*Log[1 - c*x]*PolyLog[2, c*x] - (1/6)*((2*a)/x^3 + (3*b)/x^2)*Log[1 - c*x]*PolyLog[2, c*x] + (1/3)*c^2*(3*b + 2*a*c)*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/6)*c^2*(3*b + 2*a*c)*PolyLog[3, c*x] - (1/3)*c^2*(3*b + 2*a*c)*PolyLog[3, 1 - c*x]}
{(a + b*x)*Log[1 - c*x]*PolyLog[2, c*x]/x^5, x, 51, (5*a*c^2)/(144*x^2) + (b*c^2)/(9*x) + (19*a*c^3)/(144*x) + (c^2*(4*b + 3*a*c))/(48*x) - (1/3)*b*c^3*Log[x] - (37/144)*a*c^4*Log[x] - (5/48)*c^3*(4*b + 3*a*c)*Log[x] + (1/3)*b*c^3*Log[1 - c*x] + (37/144)*a*c^4*Log[1 - c*x] + (5/48)*c^3*(4*b + 3*a*c)*Log[1 - c*x] - (5*a*c*Log[1 - c*x])/(72*x^3) - (b*c*Log[1 - c*x])/(9*x^2) - (a*c^2*Log[1 - c*x])/(16*x^2) - (c*(4*b + 3*a*c)*Log[1 - c*x])/(48*x^2) - (2*b*c^2*Log[1 - c*x])/(9*x) - (a*c^3*Log[1 - c*x])/(8*x) - (c^2*(4*b + 3*a*c)*Log[1 - c*x])/(12*x) - (1/9)*b*c^3*Log[1 - c*x]^2 - (1/16)*a*c^4*Log[1 - c*x]^2 + (a*Log[1 - c*x]^2)/(16*x^4) + (b*Log[1 - c*x]^2)/(9*x^3) + (1/12)*c^3*(4*b + 3*a*c)*Log[c*x]*Log[1 - c*x]^2 - (2/9)*b*c^3*PolyLog[2, c*x] - (1/8)*a*c^4*PolyLog[2, c*x] + (a*c*PolyLog[2, c*x])/(12*x^3) + (c*(4*b + 3*a*c)*PolyLog[2, c*x])/(24*x^2) + (c^2*(4*b + 3*a*c)*PolyLog[2, c*x])/(12*x) + (1/12)*c^3*(4*b + 3*a*c)*Log[1 - c*x]*PolyLog[2, c*x] - (1/12)*((3*a)/x^4 + (4*b)/x^3)*Log[1 - c*x]*PolyLog[2, c*x] + (1/6)*c^3*(4*b + 3*a*c)*Log[1 - c*x]*PolyLog[2, 1 - c*x] - (1/12)*c^3*(4*b + 3*a*c)*PolyLog[3, c*x] - (1/6)*c^3*(4*b + 3*a*c)*PolyLog[3, 1 - c*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x+c x^2) Log[1-d x] PolyLog[2, d x]*)


{x^1*(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x], x, 60, (53*c*x)/(192*d^3) + (11*b*x)/(27*d^2) + (a*x)/d + ((3*c + 4*b*d)*x)/(108*d^3) + (5*(3*c + 4*b*d + 6*a*d^2)*x)/(48*d^3) + (29*c*x^2)/(384*d^2) + (5*b*x^2)/(54*d) + ((3*c + 4*b*d)*x^2)/(216*d^2) + ((3*c + 4*b*d + 6*a*d^2)*x^2)/(96*d^2) + (2*b*x^3)/81 + (17*c*x^3)/(576*d) + ((3*c + 4*b*d)*x^3)/(324*d) + (3*c*x^4)/256 + (a*(1 - d*x)^2)/(8*d^2) + (29*c*Log[1 - d*x])/(192*d^4) + (5*b*Log[1 - d*x])/(27*d^3) + ((3*c + 4*b*d)*Log[1 - d*x])/(108*d^4) + ((3*c + 4*b*d + 6*a*d^2)*Log[1 - d*x])/(48*d^4) - (c*x^2*Log[1 - d*x])/(16*d^2) - (b*x^2*Log[1 - d*x])/(9*d) - ((3*c + 4*b*d + 6*a*d^2)*x^2*Log[1 - d*x])/(48*d^2) - (2/27)*b*x^3*Log[1 - d*x] - (c*x^3*Log[1 - d*x])/(24*d) - ((3*c + 4*b*d)*x^3*Log[1 - d*x])/(108*d) - (3/64)*c*x^4*Log[1 - d*x] + (c*(1 - d*x)*Log[1 - d*x])/(8*d^4) + (2*b*(1 - d*x)*Log[1 - d*x])/(9*d^3) + (a*(1 - d*x)*Log[1 - d*x])/d^2 + ((3*c + 4*b*d + 6*a*d^2)*(1 - d*x)*Log[1 - d*x])/(12*d^4) - (a*(1 - d*x)^2*Log[1 - d*x])/(4*d^2) - (c*Log[1 - d*x]^2)/(16*d^4) - (b*Log[1 - d*x]^2)/(9*d^3) + (1/9)*b*x^3*Log[1 - d*x]^2 + (1/16)*c*x^4*Log[1 - d*x]^2 - (a*(1 - d*x)*Log[1 - d*x]^2)/(2*d^2) + (a*(1 - d*x)^2*Log[1 - d*x]^2)/(4*d^2) - ((3*c + 4*b*d + 6*a*d^2)*Log[d*x]*Log[1 - d*x]^2)/(12*d^4) - ((3*c + 4*b*d + 6*a*d^2)*x*PolyLog[2, d*x])/(12*d^3) - ((3*c + 4*b*d + 6*a*d^2)*x^2*PolyLog[2, d*x])/(24*d^2) - ((3*c + 4*b*d)*x^3*PolyLog[2, d*x])/(36*d) - (1/16)*c*x^4*PolyLog[2, d*x] - ((3*c + 4*b*d + 6*a*d^2)*Log[1 - d*x]*PolyLog[2, d*x])/(12*d^4) + (1/12)*(6*a*x^2 + 4*b*x^3 + 3*c*x^4)*Log[1 - d*x]*PolyLog[2, d*x] - ((3*c + 4*b*d + 6*a*d^2)*Log[1 - d*x]*PolyLog[2, 1 - d*x])/(6*d^4) + ((3*c + 4*b*d + 6*a*d^2)*PolyLog[3, 1 - d*x])/(6*d^4)}
{x^0*(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x], x, 43, 2*a*x + (4*c*x)/(9*d^2) + (b*x)/d + ((2*c + 3*b*d)*x)/(24*d^2) + ((2*c + 3*d*(b + 2*a*d))*x)/(6*d^2) + (c*x^2)/(9*d) + ((2*c + 3*b*d)*x^2)/(48*d) + (c*x^3)/27 + (b*(1 - d*x)^2)/(8*d^2) + (2*c*Log[1 - d*x])/(9*d^3) + ((2*c + 3*b*d)*Log[1 - d*x])/(24*d^3) - (c*x^2*Log[1 - d*x])/(9*d) - ((2*c + 3*b*d)*x^2*Log[1 - d*x])/(24*d) - (1/9)*c*x^3*Log[1 - d*x] + (2*c*(1 - d*x)*Log[1 - d*x])/(9*d^3) + (b*(1 - d*x)*Log[1 - d*x])/d^2 + (2*a*(1 - d*x)*Log[1 - d*x])/d + ((2*c + 3*d*(b + 2*a*d))*(1 - d*x)*Log[1 - d*x])/(6*d^3) - (b*(1 - d*x)^2*Log[1 - d*x])/(4*d^2) - (c*Log[1 - d*x]^2)/(9*d^3) + (1/9)*c*x^3*Log[1 - d*x]^2 - (b*(1 - d*x)*Log[1 - d*x]^2)/(2*d^2) - (a*(1 - d*x)*Log[1 - d*x]^2)/d + (b*(1 - d*x)^2*Log[1 - d*x]^2)/(4*d^2) - ((2*c + 3*d*(b + 2*a*d))*Log[d*x]*Log[1 - d*x]^2)/(6*d^3) - ((2*c + 3*d*(b + 2*a*d))*x*PolyLog[2, d*x])/(6*d^2) - ((2*c + 3*b*d)*x^2*PolyLog[2, d*x])/(12*d) - (1/9)*c*x^3*PolyLog[2, d*x] - ((2*c + 3*d*(b + 2*a*d))*Log[1 - d*x]*PolyLog[2, d*x])/(6*d^3) + (1/6)*(6*a*x + 3*b*x^2 + 2*c*x^3)*Log[1 - d*x]*PolyLog[2, d*x] - ((2*c + 3*d*(b + 2*a*d))*Log[1 - d*x]*PolyLog[2, 1 - d*x])/(3*d^3) + ((2*c + 3*d*(b + 2*a*d))*PolyLog[3, 1 - d*x])/(3*d^3)}
{(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x]/x^1, x, 29, 2*b*x + (9*c*x)/(8*d) + ((c + 2*b*d)*x)/(2*d) + (c*x^2)/16 + (c*(1 - d*x)^2)/(8*d^2) + (c*Log[1 - d*x])/(8*d^2) - (1/8)*c*x^2*Log[1 - d*x] + (c*(1 - d*x)*Log[1 - d*x])/d^2 + (2*b*(1 - d*x)*Log[1 - d*x])/d + ((c + 2*b*d)*(1 - d*x)*Log[1 - d*x])/(2*d^2) - (c*(1 - d*x)^2*Log[1 - d*x])/(4*d^2) - (c*(1 - d*x)*Log[1 - d*x]^2)/(2*d^2) - (b*(1 - d*x)*Log[1 - d*x]^2)/d + (c*(1 - d*x)^2*Log[1 - d*x]^2)/(4*d^2) - ((c + 2*b*d)*Log[d*x]*Log[1 - d*x]^2)/(2*d^2) - ((c + 2*b*d)*x*PolyLog[2, d*x])/(2*d) - (1/4)*c*x^2*PolyLog[2, d*x] - ((c + 2*b*d)*Log[1 - d*x]*PolyLog[2, d*x])/(2*d^2) + (1/2)*(2*b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x] - (1/2)*a*PolyLog[2, d*x]^2 - ((c + 2*b*d)*Log[1 - d*x]*PolyLog[2, 1 - d*x])/d^2 + ((c + 2*b*d)*PolyLog[3, 1 - d*x])/d^2}
{(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x]/x^2, x, 19, 3*c*x + (3*c*(1 - d*x)*Log[1 - d*x])/d - (c*(1 - d*x)*Log[1 - d*x]^2)/d + (a*(1 - d*x)*Log[1 - d*x]^2)/x + (a - c/d^2)*d*Log[d*x]*Log[1 - d*x]^2 - 2*a*d*PolyLog[2, d*x] - c*x*PolyLog[2, d*x] + (a - c/d^2)*d*Log[1 - d*x]*PolyLog[2, d*x] - (a/x - c*x)*Log[1 - d*x]*PolyLog[2, d*x] - (1/2)*b*PolyLog[2, d*x]^2 + 2*(a - c/d^2)*d*Log[1 - d*x]*PolyLog[2, 1 - d*x] - a*d*PolyLog[3, d*x] - 2*(a - c/d^2)*d*PolyLog[3, 1 - d*x]}
{(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x]/x^3, x, 32, (-a)*d^2*Log[x] + a*d^2*Log[1 - d*x] - (a*d*Log[1 - d*x])/x - (1/4)*a*d^2*Log[1 - d*x]^2 + (a*Log[1 - d*x]^2)/(4*x^2) + (b*(1 - d*x)*Log[1 - d*x]^2)/x - (b^2*Log[d*x]*Log[1 - d*x]^2)/(2*a) + ((b + a*d)^2*Log[d*x]*Log[1 - d*x]^2)/(2*a) - 2*b*d*PolyLog[2, d*x] - (1/2)*a*d^2*PolyLog[2, d*x] + (a*d*PolyLog[2, d*x])/(2*x) + ((b + a*d)^2*Log[1 - d*x]*PolyLog[2, d*x])/(2*a) - ((a + b*x)^2*Log[1 - d*x]*PolyLog[2, d*x])/(2*a*x^2) - (1/2)*c*PolyLog[2, d*x]^2 - (b^2*Log[1 - d*x]*PolyLog[2, 1 - d*x])/a + ((b + a*d)^2*Log[1 - d*x]*PolyLog[2, 1 - d*x])/a - (1/2)*d*(2*b + a*d)*PolyLog[3, d*x] + (b^2*PolyLog[3, 1 - d*x])/a - ((b + a*d)^2*PolyLog[3, 1 - d*x])/a}
{(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x]/x^4, x, 43, (7*a*d^2)/(36*x) - (1/2)*b*d^2*Log[x] - (5/12)*a*d^3*Log[x] - (1/6)*d^2*(3*b + 2*a*d)*Log[x] + (1/2)*b*d^2*Log[1 - d*x] + (5/12)*a*d^3*Log[1 - d*x] + (1/6)*d^2*(3*b + 2*a*d)*Log[1 - d*x] - (7*a*d*Log[1 - d*x])/(36*x^2) - (b*d*Log[1 - d*x])/(2*x) - (2*a*d^2*Log[1 - d*x])/(9*x) - (d*(3*b + 2*a*d)*Log[1 - d*x])/(6*x) - (1/4)*b*d^2*Log[1 - d*x]^2 - (1/9)*a*d^3*Log[1 - d*x]^2 + (a*Log[1 - d*x]^2)/(9*x^3) + (b*Log[1 - d*x]^2)/(4*x^2) + (c*(1 - d*x)*Log[1 - d*x]^2)/x + (1/6)*d*(6*c + d*(3*b + 2*a*d))*Log[d*x]*Log[1 - d*x]^2 - 2*c*d*PolyLog[2, d*x] - (1/2)*b*d^2*PolyLog[2, d*x] - (2/9)*a*d^3*PolyLog[2, d*x] + (a*d*PolyLog[2, d*x])/(6*x^2) + (d*(3*b + 2*a*d)*PolyLog[2, d*x])/(6*x) + (1/6)*d*(6*c + d*(3*b + 2*a*d))*Log[1 - d*x]*PolyLog[2, d*x] - (1/6)*((2*a)/x^3 + (3*b)/x^2 + (6*c)/x)*Log[1 - d*x]*PolyLog[2, d*x] + (1/3)*d*(6*c + d*(3*b + 2*a*d))*Log[1 - d*x]*PolyLog[2, 1 - d*x] - (1/6)*d*(6*c + d*(3*b + 2*a*d))*PolyLog[3, d*x] - (1/3)*d*(6*c + d*(3*b + 2*a*d))*PolyLog[3, 1 - d*x]}
{(a + b*x + c*x^2)*Log[1 - d*x]*PolyLog[2, d*x]/x^5, x, 61, (5*a*d^2)/(144*x^2) + (b*d^2)/(9*x) + (19*a*d^3)/(144*x) + (d^2*(4*b + 3*a*d))/(48*x) - (1/2)*c*d^2*Log[x] - (1/3)*b*d^3*Log[x] - (37/144)*a*d^4*Log[x] - (1/48)*d^3*(4*b + 3*a*d)*Log[x] - (1/12)*d^2*(6*c + d*(4*b + 3*a*d))*Log[x] + (1/2)*c*d^2*Log[1 - d*x] + (1/3)*b*d^3*Log[1 - d*x] + (37/144)*a*d^4*Log[1 - d*x] + (1/48)*d^3*(4*b + 3*a*d)*Log[1 - d*x] + (1/12)*d^2*(6*c + d*(4*b + 3*a*d))*Log[1 - d*x] - (5*a*d*Log[1 - d*x])/(72*x^3) - (b*d*Log[1 - d*x])/(9*x^2) - (a*d^2*Log[1 - d*x])/(16*x^2) - (d*(4*b + 3*a*d)*Log[1 - d*x])/(48*x^2) - (c*d*Log[1 - d*x])/(2*x) - (2*b*d^2*Log[1 - d*x])/(9*x) - (a*d^3*Log[1 - d*x])/(8*x) - (d*(6*c + d*(4*b + 3*a*d))*Log[1 - d*x])/(12*x) - (1/4)*c*d^2*Log[1 - d*x]^2 - (1/9)*b*d^3*Log[1 - d*x]^2 - (1/16)*a*d^4*Log[1 - d*x]^2 + (a*Log[1 - d*x]^2)/(16*x^4) + (b*Log[1 - d*x]^2)/(9*x^3) + (c*Log[1 - d*x]^2)/(4*x^2) + (1/12)*d^2*(6*c + d*(4*b + 3*a*d))*Log[d*x]*Log[1 - d*x]^2 - (1/2)*c*d^2*PolyLog[2, d*x] - (2/9)*b*d^3*PolyLog[2, d*x] - (1/8)*a*d^4*PolyLog[2, d*x] + (a*d*PolyLog[2, d*x])/(12*x^3) + (d*(4*b + 3*a*d)*PolyLog[2, d*x])/(24*x^2) + (d*(6*c + d*(4*b + 3*a*d))*PolyLog[2, d*x])/(12*x) + (1/12)*d^2*(6*c + d*(4*b + 3*a*d))*Log[1 - d*x]*PolyLog[2, d*x] - (1/12)*((3*a)/x^4 + (4*b)/x^3 + (6*c)/x^2)*Log[1 - d*x]*PolyLog[2, d*x] + (1/6)*d^2*(6*c + d*(4*b + 3*a*d))*Log[1 - d*x]*PolyLog[2, 1 - d*x] - (1/12)*d^2*(6*c + d*(4*b + 3*a*d))*PolyLog[3, d*x] - (1/6)*d^2*(6*c + d*(4*b + 3*a*d))*PolyLog[3, 1 - d*x]}
